<?php
/* 
This file is part of HeatMap Theme Pro v5
Copyright: Stuart Wider
Website: HeatMapTheme.com
*/

/* Admin Page Variables
-------------------------------------------------------------- */

global $themename, $shortname, $options, $baseversion, $thisversion, $subtitle, $hmt_theme_init, $heatmap_link;

$themename = "HeatMap";
$subtitle = "Ads Theme Pro";
$baseversion = "5";
$thisversion = "5.1";
$shortname = "hmt";
$heatmap_link = "http://heatmaptheme.com";

/* Load the text domain first for tranlation then include everything in advanced.php before anything else loads 
-------------------------------------------------------------- */

load_theme_textdomain('hmth');
get_template_part("00-advanced"); 
	
/* Custom Image Headers
-------------------------------------------------------------- */

function header_style() {
    ?><style type="text/css">
        #header {
            background: url(<?php header_image(); ?>);
        }
		
    </style><?php
}


function admin_header_style() {
    ?><style type="text/css">
	
        #headimg {
            width: <?php echo HEADER_IMAGE_WIDTH; ?>px;
            height: <?php echo HEADER_IMAGE_HEIGHT; ?>px;
			text-shadow: #000000 1px 1px 2px;
        }
		
		#headimg h1, #headimg h1 a {
			padding: 0;
			margin: 0;
			margin-left: 7px;
			margin-top: 35px;
			margin-bottom: 10px;
			font-size: 1.5em;
			font-weight:bold;
			text-decoration: none;
		}
		
		#headimg #desc {
			padding: 0;
			margin: 0;
			margin-top: 0px;
			margin-left: 15px;
			font-size: 1.5em;
			font-weight: bold;
			text-decoration: none;	
		}

    </style>
<?php
}

if(!function_exists('hmt_add_to_adpage_head'))
{
	function hmt_add_to_adpage_head()
	{
		hmt_questionmark_style ();
		?>
			   	<style type='text/css'>
					.nav-tab {
						margin-right: 5px;
						padding-left: 5px;
						padding-right: 5px;
						font-size: 11px;
					}
				</style>
		<?php
	}
}

if(!function_exists('hmt_add_to_optionpage_head'))
{
	function hmt_add_to_optionpage_head()
	{
		hmt_questionmark_style ();
		?>
        		<style type='text/css'>
				.nav-tab {
					margin-right: 3px;
					padding-left: 5px;
					padding-right: 5px;
					font-size: 11px;
					font-weight:normal;
				}
				div.hmt-admin-wrap td {
					    font-size: 13px;
				}

			</style>
		<?php
	}
}

if (!function_exists('hmt_questionmark_style')):
function hmt_questionmark_style () { ?>
       	<style type='text/css'>

		.questionmark {
		    background: url("<?php echo get_template_directory_uri(); ?>/images/preset-images/questionmark.gif") repeat scroll 0 0 transparent;
		    display: inline-block;
		    height: 13px;
		    width: 12px;
  	   	    float: right;
  	   	    margin-right: 10px;
		}
		body .widefat td{
			border-width:0;
		}

		.hmt-admin-wrap .widefat thead tr th
		{
		   background:none;
		   padding: 6px 7px;
		}

		.hmt-admin-wrap .widefat thead tr th:hover
		{
		   background:url("images/menu-bits.gif?ver=20100610") no-repeat scroll 677px -111px transparent;
		}

		.hmt-admin-wrap .widefat thead 
		{
		   background: url("images/gray-grad.png") repeat-x scroll left top #DFDFDF;
		}

		.img_valign{
		    vertical-align: bottom;
		}

		</style>
<?php 
}
endif;

/* Search
-------------------------------------------------------------- */

if (!function_exists('hmt_search')):
function hmt_search () { 
	
        print '<!--';
        print 'The Search Bar';
        print '~~~ -->';
		
		if (!hmt4_get_option('hmt_hide_search'))  
		{
		?>
			<div id="search-bar">
			
				<div id="search-bar-content">
					<?php hmt_google_search(); /* hmt_google search will output the google search code, but if there is none, you just get the wordpress search instead */ ?>
				</div> <!-- id="search-bar-content" -->
	
			</div> <!-- id="search-bar" -->
		<?php 
		} 
}
endif;


/* Social Icons
-------------------------------------------------------------- */

if (!function_exists('hmt_display_social_buttons')):
function hmt_display_social_buttons ($type) {        

	$feedburner_output = hmt4_get_option('hmt_feedburner_id');						// get the feedburner id from the options page (for both comments and posts)
	$feedburner_comments_output = hmt4_get_option('hmt_feedburner_comments_id');
	$facebook_output = hmt4_get_option('hmt_facebook_id');
	$twitter_output = hmt4_get_option('hmt_twitter_id');
	$myspace_output = hmt4_get_option('hmt_myspace_id');
	$youtube_output = hmt4_get_option('hmt_youtube_id');
	$linkedin_output = hmt4_get_option('hmt_linkedin_id');
	$googleplus_output = hmt4_get_option('hmt_googleplus');
		
	$this_language = WPLANG;

	if (!hmt4_get_option('hmt_hide_rss_icon')) {
		print '<span class="social-image">';
		
		if ($feedburner_output) {
			print '<a href="http://feeds2.feedburner.com/';
			print $feedburner_output;
			print '" target="_blank"><img src="';
			print get_stylesheet_directory_uri();
			print '/images/rss-feed-v4.png" width="23" height="22" /></a>';
		}
		else
		{
			print '<a href="';
			print bloginfo('rss2_url');
			print'"><img src="';
			print get_stylesheet_directory_uri();
			print '/images/rss-feed-v4.png" width="23" height="22" /></a>';
		}
		print '</span>';
	}
	

	if (!hmt4_get_option('hmt_hide_rss_comments_icon')) {
	print '<span class="social-image">';
	
		if ($feedburner_comments_output) {
			print '<a href="http://feeds2.feedburner.com/';
			print $feedburner_comments_output;
			print '" target="_blank"><img src="';
			print get_stylesheet_directory_uri();
			print '/images/rss-comments-v4.png" width="23" height="22" /></a>';
		}
		else {
			print '<a href="';
			print bloginfo('comments_rss2_url');
			print'"><img src="';
			print get_stylesheet_directory_uri();
			print '/images/rss-comments-v4.png" width="23" height="22" /></a>';
		}
		print '</span>';
	}
	
	
	if ($feedburner_output) { 
		print '<span class="social-image">';
		print '<a href="http://feedburner.google.com/fb/a/mailverify?uri=';
		print $feedburner_output;
		
		if ($this_language) {
			print '&amp;loc=' . $this_language . '" target="_blank">';
		} 
		else {
			print '&amp;loc=en_US" target="_blank">';
		}
		print '<img src="';
		print get_stylesheet_directory_uri();
		print '/images/feedburner.png" width="23" height="22" /></a>';
		print '</span>';
	}
	
	if ($facebook_output) {
		print '<span class="social-image">';
		print '<a href="http://facebook.com/';
		print $facebook_output;
		print '" target="_blank"><img src="';
		print get_stylesheet_directory_uri();
		print '/images/facebook.png" width="23" height="22" /></a>';
		print '</span>';
	} 
	
	if ($twitter_output) {
		print '<span class="social-image">';
		print '<a href="http://twitter.com/';
		print $twitter_output;
		print '" target="_blank"><img src="';
		print get_stylesheet_directory_uri();
		print '/images/twitter.png" width="23" height="22" /></a>';
		print '</span>';
	} 
	
	if ($googleplus_output) {
		print '<span class="social-image">';
		print '<a href="';
		print $googleplus_output;
		print '" target="_blank"><img src="';
		print get_stylesheet_directory_uri();
		print '/images/googleplus.png" width="23" height="22" /></a>';
		print '</span>';
	} 
	
	if ($myspace_output) {
		print '<span class="social-image">';
		print '<a href="http://myspace.com/';
		print $myspace_output;
		print '" target="_blank"><img src="';
		print get_stylesheet_directory_uri();
		print '/images/myspace.png" width="23" height="22" /></a>';
		print '</span>';
	}
	
	if ($youtube_output) {
		print '<span class="social-image">';
		print '<a href="http://youtube.com/';
		print $youtube_output;
		print '" target="_blank"><img src="';
		print get_stylesheet_directory_uri();
		print '/images/youtube.png" width="23" height="22" /></a>';
		print '</span>';
	}
	
	if ($linkedin_output) {
		print '<span class="social-image">';
		print '<a href="';
		print $linkedin_output;
		print '" target="_blank"><img src="';
		print get_stylesheet_directory_uri();
		print '/images/linkedin.png" width="23" height="22" /></a>';
		print '</span>';
	}

}
endif;


/* Nav Bar Social Icons
-------------------------------------------------------------- */

if (!function_exists('hmt_rss_social')):
function hmt_rss_social () {
 
	if (!hmt4_get_option('hmt_hide_rss')) 
	{
	?>

		<div id="rss-bar">
		
			<div id="rss-bar-content">
            
            	<?php hmt_display_social_buttons ('nav'); ?> 
  
       		</div> <!-- id="rss-bar-content" -->
    
       </div> <!-- id="rss-bar" -->
                
	<?php 
    }
}	
endif;


/* Feedburner Widget
-------------------------------------------------------------- */

if (!function_exists('hmt_widget_feedburner')):
function hmt_widget_feedburner ($args) {
	
	extract($args);
	$output = hmt4_get_option('hmt_feedburner_id');

	echo $before_widget;
	echo $before_title;  echo hmt4_get_option('hmt_feedburner_title'); echo $after_title; 
	if ($output!='') 
	{
	echo '<form action="http://feedburner.google.com/fb/a/mailverify" method="post" target="popupwindow" onsubmit="window.open(\'http://feedburner.google.com/fb/a/mailverify?uri=';
	echo stripslashes($output); 
	$this_language = WPLANG;
	echo '\', \'popupwindow\', \'scrollbars=yes,width=550,height=520\');return true"><input class="fb-email-text" type="text" id="fbinput" name="email"/><input type="hidden" value="'; echo stripslashes($output); echo '" name="uri"/><input type="hidden" name="loc" value="'; if ($this_language) {print $this_language;} else {print 'en_US';} echo '"/><input class="fb-submit-button" id="fbsubmit" type="submit" value="'; _e('Subscribe','hmth'); echo '" /></form>';
	}
	else
	{
	echo '<strong>No Feedburner ID:</strong><br/>
Please add a Feedburner ID in the HeatMap Theme Options Page';
	}
	echo $after_widget;
	echo "\n";	

}
endif;

if (!function_exists('hmt_widget_feedburner_controller')):
function hmt_widget_feedburner_controller () {

		$options = get_option( "hmt_theme_settings" );

		if ( isset( $_POST['hmt_feedburner_title_7_submit'] ) && $_POST["hmt_feedburner_title_7_submit"] ) {

			$options['hmt_feedburner_title'] = strip_tags(stripslashes($_POST["hmt_feedburner_title_7"]));
			update_option('hmt_theme_settings', $options);

		}
		if(isset($options['hmt_feedburner_title']))
		{
			$title = htmlspecialchars($options['hmt_feedburner_title'], ENT_QUOTES);
		}
		else
		{
			$title='';
		}

	?>
				<p><label for="hmt_feedburner_title_7"><?php _e('Title:','hmth'); ?> <input style="width: 230px;" id="hmt_feedburner_title_7" name="hmt_feedburner_title_7" type="text" value="<?php echo $title; ?>" /></label></p>
				<input type="hidden" id="hmt_feedburner_title_7_submit" name="hmt_feedburner_title_7_submit" value="1" />
	<?php
}
endif;


/* RSS Icons Widget
-------------------------------------------------------------- */

if (!function_exists('hmt_widget_rss_icons')):
function hmt_widget_rss_icons ($args) {
	
	extract($args);

	echo $before_widget;
	echo $before_title; hmt4_echo_option('hmt_social_icons_title'); echo $after_title; 
	echo '<ul><li>';
	
  	hmt_display_social_buttons ('widget');
	
	echo '</li></ul>';
	echo $after_widget;
	echo "\n";	
}
endif;

if (!function_exists('hmt_widget_rss_icons_controller')):
function hmt_widget_rss_icons_controller () {

		$options = $newoptions = get_option( "hmt_theme_settings" );

		if ( isset( $_POST['hmt_social_icons_title_7_submit'] ) && $_POST["hmt_social_icons_title_7_submit"] ) {

			$options['hmt_social_icons_title'] = strip_tags(stripslashes($_POST["hmt_social_icons_title_7"]));
			update_option('hmt_theme_settings', $options);

		}
		if(!isset($options['hmt_social_icons_title']))
		{
			$title = '';
		}
		else
		{
			$title = htmlspecialchars($options['hmt_social_icons_title'], ENT_QUOTES);
		}

	?>
				<p><label for="hmt_social_icons_title_7"><?php _e('Title:','hmth'); ?> <input style="width: 230px;" id="hmt_social_icons_title_7" name="hmt_social_icons_title_7" type="text" value="<?php echo $title; ?>" /></label></p>
				<input type="hidden" id="hmt_social_icons_title_7_submit" name="hmt_social_icons_title_7_submit" value="1" />
	<?php
}
endif;


/* Recent Posts Widget PLUS (includes excerpt and thumbnail images)
-------------------------------------------------------------- */

if (!function_exists('hmt_widget_recent_posts_plus')):
function hmt_widget_recent_posts_plus ($args) {
	
	extract($args);
	global $post; 
	global $more;
	global $ids;
	
	echo $before_widget;
	echo $before_title; hmt4_echo_option('hmt_recent_posts_plus_title'); echo $after_title;
	
	$numposts = substr(hmt4_get_option('hmt_recent_posts_plus_num'),0,2); 
	if ($numposts == '') $numposts = '3'; 


	if(trim(hmt4_get_option('hmt_recent_posts_include_cat'))!="")
	{
		$recent7 = new WP_Query(array('post__not_in' => $ids, 'showposts' => $numposts,  'category__in' => explode(",",hmt4_get_option('hmt_recent_posts_include_cat') ) )); 	// Only get the query for posts that are NOT already showing on the page
	}
	else
	{
		$recent7 = new WP_Query(array('post__not_in' => $ids, 'showposts' => $numposts )); 	
	}
	echo '<ul><li>'; 

	$first_time_through7 = TRUE;		// This allows us to do something sensible with spacing the first time through the loop
	
	while($recent7->have_posts()) : $recent7->the_post();
		
		if (!$first_time_through7) echo '<div class="clearFloat-spacer">&nbsp;</div>';
		
		$first_time_through7 = FALSE;
		
		echo '<h5><a href="'; the_permalink(); echo '" rel="bookmark">'; the_title(); echo '</a></h5>';
		
		if( get_post_meta($post->ID, "thumbnail", true) ){   // Get the thumbnail image from a custom field if it is defined, and then show it
			echo '<div class="thumbnail">';
				echo '<a href="'; 
				if( get_post_meta($post->ID, "featured-img-link", true)){ echo get_post_meta($post->ID, "featured-img-link", true); } else { the_permalink(); } 
				if( get_post_meta($post->ID, "featured-img-link-nofollow", true)){  echo '" rel="nofollow">'; } else {echo '" rel="bookmark">';}
				echo '<img src="'; echo get_post_meta($post->ID, "thumbnail", true); echo '" alt="'; echo get_post_meta($post->ID, "thumbnail-alt", true); echo '" border="0"/>';
				echo '</a>';
			echo '</div>';
			echo "\n";	
		}
		else if (function_exists('has_post_thumbnail') && has_post_thumbnail()) {	// Get the thumbnail - added wp auto thumbnail features 25/02/2010

          
        		if (get_post_meta($post->ID, "aff-link", true)) $hmt_aff_link = get_post_meta($post->ID, "aff-link", true);
        		if (get_post_meta($post->ID, "aff-link-text", true)) $hmt_aff_link_text = get_post_meta($post->ID, "aff-link-text", true);

			echo '<div class="thumbnail">';
			echo '<a href="';
			if( get_post_meta($post->ID, "featured-img-link", true)){  echo get_post_meta($post->ID, "featured-img-link", true); } else { the_permalink(); } 
			if( get_post_meta($post->ID, "featured-img-link-nofollow", true)){  echo '" rel="nofollow">'; } else {echo '" rel="bookmark">';}
				the_post_thumbnail();
				echo '</a>';
			echo '</div>';
			echo "\n";	
		}
			
		
		if( get_post_meta($post->ID, "short-excerpt", true)) {		// Get a short excerpt from a custom field if it is defined, and then show it
			echo '<p>' . get_post_meta($post->ID, "short-excerpt", true) . '</p>';
		}
		else if( is_numeric( hmt4_get_option( 'hmt_auto_excert_len_recent_post' ) ) && hmt4_get_option( 'hmt_auto_excert_len_recent_post' ) != "" )
		{

			echo '<p>' . remove_hmtad_shortcode(trim( implode( " ", array_slice( explode( " ",  strip_tags( $post->post_content) ), 0, hmt4_get_option( 'hmt_auto_excert_len_recent_post' ) ) ) )) . '...</p>';

		}
			echo "\n";	
		
		if (get_post_meta($post->ID, "short-more-text", true)) {	// Get the 'short more text' from a custom field if it is defined, and then show it
			echo '<p class="more-link"><a href="'; the_permalink(); echo '" rel="bookmark">';
			echo get_post_meta($post->ID, "short-more-text", true) . '</a></p>';
			echo "\n";	
		}	
		
	endwhile;
	
	echo '</li></ul>';

	echo $after_widget;
	echo "\n";	
}
endif;

if (!function_exists('hmt_widget_recent_posts_plus_controller')):
function hmt_widget_recent_posts_plus_controller () {

		 $newoptions = get_option( "hmt_theme_settings" );

		if ( isset( $_POST['hmt_recent_posts_plus_title_7_submit'] ) && $_POST["hmt_recent_posts_plus_title_7_submit"] ) {
		
			if(isset($_POST['hmt_recent_posts_exclude_7cat']))
			{
				$hmt_recent_posts_exclude_7cat=( array ) $_POST['hmt_recent_posts_exclude_7cat'];
			}
			else
			{
				$hmt_recent_posts_exclude_7cat=array();
			}		

			$newoptions['hmt_recent_posts_plus_title'] = strip_tags(stripslashes($_POST["hmt_recent_posts_plus_title_7"]));
			$newoptions['hmt_recent_posts_plus_num'] = $_POST["hmt_recent_posts_plus_num_7"];
			$newoptions['hmt_recent_posts_include_cat']= (string) implode("," , $hmt_recent_posts_exclude_7cat );
			$newoptions['hmt_auto_excert_len_recent_post'] = $_POST["hmt_auto_excert_len_recent_post_7"];

			update_option('hmt_theme_settings', $newoptions);
		}
		if(isset($newoptions['hmt_recent_posts_plus_title']))
		{
			$title = htmlspecialchars($newoptions['hmt_recent_posts_plus_title'], ENT_QUOTES);
		}
		else
		{
			$title="";
		}
$random_no = rand(1,100);
	?>

<script type="text/javascript">

function selectAll<?php echo $random_no; ?>(selObj)
{

for (i = 0; i < selObj.options.length; i ++)
{
selObj.options[i].selected = false;
}
}

function deselect_others<?php echo $random_no; ?>(selObj)
{

for (i = 1; i < selObj.options.length; i ++)
{
selObj.options[i].selected = false;
}
}

function check_if_1st_selected<?php echo $random_no; ?>(selObj)
{
	if(selObj.options[0].selected==true)
	{
		deselect_others<?php echo $random_no; ?>(selObj);
	}
}
</script>


				<p><label for="hmt_recent_posts_plus_title_7"><?php _e('Title:','hmth'); ?> <input style="width: 230px;" id="hmt_recent_posts_plus_title_7" name="hmt_recent_posts_plus_title_7" type="text" value="<?php  echo $title;  ?>" /></label></p>

				<p><label for="hmt_recent_posts_plus_num_7"><?php _e('Number of Recent Posts','hmth'); ?>:

 								<select 
                                
                                style="width:150px;"
                                name="hmt_recent_posts_plus_num_7"
                                id="hmt_recent_posts_plus_num_7">
                                
                                <option value="3 Posts" 
                                    <?php if ( isset($newoptions['hmt_recent_posts_plus_num']) && $newoptions['hmt_recent_posts_plus_num']  == "3 Posts" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("3 Posts",'hmth'); ?>
                                </option>
                                
                                <option value="4 Posts"
                                   <?php if ( isset($newoptions['hmt_recent_posts_plus_num']) &&  $newoptions['hmt_recent_posts_plus_num']  == "4 Posts" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("4 Posts",'hmth'); ?>
                                </option>    
                                
                        		<option value="5 Posts"
                                   <?php if (  isset($newoptions['hmt_recent_posts_plus_num']) && $newoptions['hmt_recent_posts_plus_num']  == "5 Posts" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("5 Posts",'hmth'); ?>
                                </option>  
                                
                        		<option value="6 Posts"
                                   <?php if ( isset($newoptions['hmt_recent_posts_plus_num']) &&  $newoptions['hmt_recent_posts_plus_num']  == "6 Posts" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("6 Posts",'hmth'); ?>
                                </option>  
                                
                              	<option value="7 Posts"
                                   <?php if ( isset($newoptions['hmt_recent_posts_plus_num']) &&  $newoptions['hmt_recent_posts_plus_num']  == "7 Posts" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("7 Posts",'hmth'); ?>
                                </option> 
                                
                                <option value="8 Posts"
                                   <?php if ( isset($newoptions['hmt_recent_posts_plus_num']) &&  $newoptions['hmt_recent_posts_plus_num']  == "8 Posts" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("8 Posts",'hmth'); ?>
                                </option>  
                                
                               	<option value="9 Posts"
                                   <?php if ( isset($newoptions['hmt_recent_posts_plus_num']) &&  $newoptions['hmt_recent_posts_plus_num'] == "9 Posts" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("9 Posts",'hmth'); ?>
                                </option>  

                                
                                <option value="10 Posts"
                                   <?php if ( isset($newoptions['hmt_recent_posts_plus_num']) &&  $newoptions['hmt_recent_posts_plus_num']  == "10 Posts" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("10 Posts",'hmth'); ?>
                                </option>  
                               
                                </select>   

			</label></p>

			<p><label for="hmt_recent_posts_include_cat_7"><?php _e('Include Post Categories','hmth'); ?>:


			<select onChange="check_if_1st_selected<?php echo $random_no; ?>(document.getElementById('hmt_recent_posts_include_<?php echo $random_no; ?>cat'))"  multiple="multiple" size="10" style="width:230px; height:auto;"  name="hmt_recent_posts_exclude_7cat[]" id="hmt_recent_posts_include_<?php echo $random_no; ?>cat" > 
				<?php							
						$allcat = get_categories();
						if(isset($newoptions['hmt_recent_posts_include_cat']))
						{
							$hmt_recent_posts_include_cat=$newoptions['hmt_recent_posts_include_cat'];
						}
						else
						{
							$hmt_recent_posts_include_cat="";
						}
						$currentcat = explode(",", htmlspecialchars( stripslashes( $hmt_recent_posts_include_cat ) ) );
						
						
						echo '<option onclick="deselect_others'.$random_no.'(document.getElementById(\'hmt_recent_posts_include_'. $random_no.'cat\'))" value=""';
						if(trim($hmt_recent_posts_include_cat)=="" )
						{
							echo " selected='selected' ";
						}
						echo '>Include All</option>';
						

						foreach( $allcat as $singlecat )
						{
							echo "<option value='" . $singlecat->cat_ID . "'";
							if( in_array( $singlecat->cat_ID , $currentcat ) )
							{
								echo " selected='selected' ";
							}
							echo " >" .  $singlecat->cat_name . "</option>";
						}
 
				?>
			</select>

			</label><a href="javascript:void(0)" onclick="selectAll<?php echo $random_no; ?>(document.getElementById('hmt_recent_posts_include_<?php echo $random_no; ?>cat'))"><?php _e('deselect all','hmth'); ?></a></p>

			<p><label for="hmt_auto_excert_len_recent_post_7"><?php _e('Auto Excerpt Length','hmth'); ?>: <input  id="hmt_auto_excert_len_recent_post_7" name="hmt_auto_excert_len_recent_post_7" style="width: 50px;" type="text" value="<?php if(isset($newoptions['hmt_auto_excert_len_recent_post'])){ echo $newoptions['hmt_auto_excert_len_recent_post']; } ?>" /></label></p>

			<input type="hidden" id="hmt_recent_posts_plus_title_7_submit" name="hmt_recent_posts_plus_title_7_submit" value="1" />
	<?php
}
endif;

/* Encoding functions to workaround mod sec if it has strict settings on the host (DEPRECATED)
-------------------------------------------------------------- */

function strip_hmt_encoding ($hmt_encoded_string){
	$hmt_encoded_string = str_replace('[hmt-encode-1]','http',$hmt_encoded_string);
	return $hmt_encoded_string;
}


/* Function to echo code configured in the options admin and output error if not configured (DEPRECATED)
-------------------------------------------------------------- */

function hmt_option($option_id) {
	$output = strip_hmt_encoding( get_option($option_id));
	if ($output!='')  echo stripslashes($output); 
}


/* Function to return code configured in the options admin (DEPRECATED)
-------------------------------------------------------------- */

function hmt_get_option($option_id) {
	$output = strip_hmt_encoding( get_option($option_id)); 
	$returned_string = stripslashes($output); 
	return $returned_string;
}


/* HMT4 Options Array Functions
-------------------------------------------------------------- */

function hmt4_initialise_option() {
	
	global $shortname, $options, $hmt_theme_init;
	
	if (! get_option('hmt_theme_settings')) {
		add_option ('hmt_theme_settings', $hmt_theme_init);
	}
}


function hmt4_echo_option($element) { // replaces hmt_option
	global $hmt_current_options;
	
	if (!$hmt_current_options) {
		$hmt_current_options = get_option('hmt_theme_settings');
	}
	
	if ( isset($hmt_current_options[$element]) ) {
		echo stripslashes($hmt_current_options[$element]); 
		return true;
	} else {
		return false;
	}
}


function hmt4_get_option($element) {
	
	global $hmt_current_options;
	
	if (!$hmt_current_options) {
		$hmt_current_options = get_option('hmt_theme_settings');
	}
	
	if ( isset($hmt_current_options[$element]) ) {
		return stripslashes($hmt_current_options[$element]); 
	} else {
		return false;
	}
}


function hmt4_update_option($element, $value) {
	
	global $hmt_current_options;
	
	if (!$hmt_current_options) {
		$hmt_current_options = get_option('hmt_theme_settings');
	}

	isset($hmt_current_options[$element]) ? $currentvalue=$hmt_current_options[$element] : $currentvalue="";
	if ( $value != $currentvalue ) {
		$hmt_current_options[$element] = $value;
		return $hmt_current_options[$element] = $value;
	} else {
		return false;
	}
}


function hmt4_write_options () {
	global $hmt_current_options;
	update_option('hmt_theme_settings', $hmt_current_options );
}


function hmt4_delete_option($element) {
	
	global $hmt_current_options;
	
	if (!$hmt_current_options) {
		$hmt_current_options = get_option('hmt_theme_settings');
	}
	
	if ( isset($hmt_current_options[$element]) && $hmt_current_options[$element] ) {	
		if( isset($hmt_current_options[$element]))
		{
			 $hmt_current_options[$element] ="";
		}
		return $hmt_current_options[$element];
	} else {
		return false;
	}
}

/* Demo Ads
-------------------------------------------------------------- */

if (!function_exists('hmt_demo_ad')):
function hmt_demo_ad ($output) {

	// if a demo ad string is in the ad, then replace it with a demo ad
	
	switch ($output) {
    case '[-PLACE 120 x 240 AD HERE-]':
        $output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/120x240.png"  width="120" height="240"/>';
        break;
		
	case '[-PLACE 120 x 600 AD HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/120x600.png"  width="120" height="600"/>';
		break;

	case '[-PLACE 728 x 15 LINK UNIT HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/728x15link.png"  width="728" height="15"/>';
		break;	
		
	case '[-PLACE 468 x 15 LINK UNIT HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/468x15link.png"  width="468" height="15"/>';
		break;	
		
	case '[-PLACE 120 x 90 LINK UNIT HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/120x90link.png"  width="120" height="90"/>';
		break;		

	case '[-PLACE 125 x 125 AD HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/125x125.png"  width="125" height="125"/>';
		break;		
		
	case '[-PLACE 160 x 600 AD HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/160x600.png"  width="160" height="600"/>';
		break;
		
	case '[-PLACE 160 x 90 LINK UNIT HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/160x90link.png"  width="160" height="90"/>';
		break;
		
	case '[-PLACE 180 x 150 AD HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/180x150.png"  width="180" height="150"/>';
		break;
		
    case '[-PLACE 180 x 90 LINK UNIT HERE-]':
        $output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/180x90link.png"  width="180" height="90"/>';
        break;
		
	case '[-PLACE 200 x 200 AD HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/200x200.png"  width="200" height="200"/>';
		break;
		
	case '[-PLACE 200 x 90 LINK UNIT HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/200x90link.png"  width="200" height="90"/>';
		break;		

	case '[-PLACE 234 x 60 AD HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/234x60.png"  width="234" height="60"/>';
		break;		

	case '[-PLACE 250 x 250 AD HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/250x250.png"  width="250" height="250"/>';
		break;	
		
	case '[-PLACE 300 x 250 AD HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/300x250.png"  width="300" height="250"/>';
		break;
		
	case '[-PLACE 336 x 280 AD HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/336x280.png"  width="336" height="280"/>';
		break;
		
	case '[-PLACE 468 x 60 AD HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/468x60.png"  width="468" height="60"/>';
		break;			

	case '[-PLACE 728 x 90 AD HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/728x90.png"  width="728" height="90"/>';
		break;		
		
	case '[-PLACE 645 x 90 AD HERE-]':
		$output = '<img src="' . get_template_directory_uri() . '/images/demo-ads/645x90.png"  width="645" height="90"/>';
		break;													
	}
	return $output;
	
}
endif;

/* Show ad on this page
-------------------------------------------------------------- */

if (!function_exists('hmt_show_ad')):
function hmt_show_ad ($this_ad, $args) {
	
	extract($args);
	global $hmt_all_ads_off;
	
	if (!$hmt_all_ads_off) {
		$output = hmt4_get_option($this_ad);
		
		// Only show an ad if it is ticked in the options admin
		if ((is_page() and hmt4_get_option($this_ad . '_Page')) ||
			(is_single() and hmt4_get_option($this_ad . '_Post')) ||   
			(is_category() and hmt4_get_option($this_ad . '_Category')) ||
			(is_search() and hmt4_get_option($this_ad . '_Search')) ||
			(is_archive() and hmt4_get_option($this_ad . '_Archive')) ||	
			(is_home() and hmt4_get_option($this_ad . '_Home')) ||
			is_404())
			{ 
			if ($output!='') {
				echo $before_widget;
				echo hmt_display_rotated_ad($output);
				echo $after_widget;
			}
		}
	}
}
endif;

if (!function_exists('hmt_display_rotated_ad')):
function hmt_display_rotated_ad($output) {

	$output=stripslashes($output);
	
	$output = hmt_demo_ad ($output); /*check for demo ads*/
	
	if (strpos($output, "[ROTATE]") !== FALSE) {
		if (strpos($output, "[NOCACHE]") !== FALSE) {
			$output=str_replace("[NOCACHE]","",$output);
			$output=str_replace("\r\n","&nl;",$output);
			$output=str_replace("\n","&nl;",$output);
			$output=str_replace("\\","\\\\",$output);
			$output=str_replace("'","&qut;",$output);
			$output=str_replace("<","&lt;",$output);
			$output=str_replace(">","&gt;",$output);
			$ad_arr=explode("[ROTATE]",$output);
			$output=implode("','",$ad_arr);
			$ran=rand(7,77);
			return "\n<script type='text/javascript'>\n ad".$ran." = ['".$output."']; \n  document.write(rotate_ad(ad".$ran.")); \n </script>\n";

		}
		else
		{
			$ad_arr=explode("[ROTATE]",$output);
			return $ad_arr[ rand(1,count($ad_arr)) -1 ];
		}
	}
	else
	{
		return $output;
	}
}
endif;

if (!function_exists('hmt_widget_ad_unit_controller')):
function hmt_widget_ad_unit_controller ($this_ad) {

		$options =  get_option( "hmt_theme_settings" );

		if ( isset( $_POST[$this_ad.'_7_submit'] ) && $_POST[$this_ad.'_7_submit'] ) {

			$options[$this_ad] = isset($_POST[$this_ad])? stripslashes($_POST[$this_ad] ):"";
			$options[$this_ad.'_Home'] = isset($_POST[$this_ad.'_Home'])? stripslashes($_POST[$this_ad.'_Home'] ):"";
			$options[$this_ad.'_Page'] = isset($_POST[$this_ad.'_Page'])? stripslashes($_POST[$this_ad.'_Page'] ):"";
			$options[$this_ad.'_Post'] = isset($_POST[$this_ad.'_Post'])? stripslashes($_POST[$this_ad.'_Post'] ):"";
			$options[$this_ad.'_Category'] = isset($_POST[$this_ad.'_Category'])? stripslashes($_POST[$this_ad.'_Category'] ):"";
			$options[$this_ad.'_Search'] = isset($_POST[$this_ad.'_Search'])? stripslashes($_POST[$this_ad.'_Search'] ):"";
			$options[$this_ad.'_Archive'] = isset($_POST[$this_ad.'_Archive'])? stripslashes($_POST[$this_ad.'_Archive'] ):"";
			//$options[$this_ad.'_name'] = stripslashes($_POST[$this_ad.'_name'] );
			update_option('hmt_theme_settings', $options);

		}

if( $options[ $this_ad.'_Home'] == ''  )
{
$checkbox['Home'] = '';
}
else
{
$checkbox['Home'] = ' checked="checked" ';
}

if( $options[ $this_ad.'_Page'] == ''  )
{
$checkbox['Page'] = '';
}
else
{
$checkbox['Page'] = ' checked="checked" ';
}

if( isset($options[ $this_ad.'_Post']) && $options[ $this_ad.'_Post'] == ''  )
{
$checkbox['Post'] = '';
}
else
{
$checkbox['Post'] = ' checked="checked" ';
}

if( isset($options[ $this_ad.'_Category']) && $options[ $this_ad.'_Category'] == ''  )
{
$checkbox['Category'] = '';
}
else
{
$checkbox['Category'] = ' checked="checked" ';
}

if( isset($options[ $this_ad.'_Search']) && $options[ $this_ad.'_Search'] == ''  )
{
$checkbox['Search'] = '';
}
else
{
$checkbox['Search'] = ' checked="checked" ';
}

if( isset($options[ $this_ad.'_Archive']) && $options[ $this_ad.'_Archive'] == ''  )
{
$checkbox['Archive'] = '';
}
else
{
$checkbox['Archive'] = ' checked="checked" ';
}

echo '
<table>
	<tr>
    	<td width="250"  valign="top">
        	<!--<input type="text" value="'. $options[ $this_ad.'_name'] .'" id="'.$this_ad.'_name" name="'.$this_ad.'_name" style="width:200px; font-size:11px; font-weight:bold;"><br/>-->
            <input type="checkbox" '.$checkbox['Home'].'  value="true" id="'.$this_ad.'_Home" name="'.$this_ad.'_Home" /> <label for="'.$this_ad.'_Home">'. __("Home",'hmth') .'</label><br/>
            <input type="checkbox" '.$checkbox['Page'].'  value="true" id="'.$this_ad.'_Page" name="'.$this_ad.'_Page" /> <label for="'.$this_ad.'_Page">'. __('Page','hmth') .'</label><br/>
            <input type="checkbox" '.$checkbox['Post'].'  value="true" id="'.$this_ad.'_Post" name="'.$this_ad.'_Post" /> <label for="'.$this_ad.'_Post">'. __('Post','hmth') .'</label><br/>
            <input type="checkbox" '.$checkbox['Category'].'  value="true" id="'.$this_ad.'_Category" name="'.$this_ad.'_Category" /> <label for="'.$this_ad.'_1_Category">'. __('Category','hmth') .'</label><br/>
            <input type="checkbox" '.$checkbox['Search'].'  value="true" id="'.$this_ad.'_Search" name="'.$this_ad.'_Search" /> <label for="'.$this_ad.'_Search">'. __('Search','hmth') .'</label><br/>
            <input type="checkbox" '.$checkbox['Archive'].' value="true" id="'.$this_ad.'_Archive" name="'.$this_ad.'_Archive" /> <label for="'.$this_ad.'_Archive">'. __('Archive','hmth') .'</label><br/>

		</td>
        <td width="350" valign="top">
        	<textarea  style="width:340px; height:120px; font-size:11px;" name="'.$this_ad.'">'; 
			echo htmlspecialchars(stripslashes($options[ $this_ad ])); 
			echo '</textarea>
        	<input type="hidden" id="hmt_ads_7_submit" name="'.$this_ad.'_7_submit" value="1" />
        </td>
	</tr>
</table>';
	
}
endif;

/* Adsense Ad Units
-------------------------------------------------------------- */

function hmt_widget_ad_unit_1($args) {
	hmt_show_ad('hmt_ad_unit_1', $args);
}

function hmt_widget_ad_unit_1_controller() {
	hmt_widget_ad_unit_controller('hmt_ad_unit_1');
}

function hmt_widget_ad_unit_2($args) {
	hmt_show_ad('hmt_ad_unit_2', $args);
}

function hmt_widget_ad_unit_2_controller() {
	hmt_widget_ad_unit_controller('hmt_ad_unit_2');
}

function hmt_widget_ad_unit_3($args) {
	hmt_show_ad('hmt_ad_unit_3', $args);
}

function hmt_widget_ad_unit_3_controller() {
	hmt_widget_ad_unit_controller('hmt_ad_unit_3');
}



/* Adsense Link Units
-------------------------------------------------------------- */

function hmt_widget_link_unit_1($args) {
	hmt_show_ad('hmt_link_unit_1', $args);
}

function hmt_widget_link_unit_1_controller() {
	hmt_widget_ad_unit_controller('hmt_link_unit_1');
}

function hmt_widget_link_unit_2($args) {
	hmt_show_ad('hmt_link_unit_2', $args);
}

function hmt_widget_link_unit_2_controller() {
	hmt_widget_ad_unit_controller('hmt_link_unit_2');
}

function hmt_widget_link_unit_3($args) {
	hmt_show_ad('hmt_link_unit_3', $args);
}

function hmt_widget_link_unit_3_controller() {
	hmt_widget_ad_unit_controller('hmt_link_unit_3');
}


/* Additional Ad Units
-------------------------------------------------------------- */

function hmt_widget_additional_unit_1($args) {
	hmt_show_ad('hmt_additional_unit_1', $args);
}

function hmt_widget_additional_unit_1_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_1');
}

function hmt_widget_additional_unit_2($args) {
	hmt_show_ad('hmt_additional_unit_2', $args);
}

function hmt_widget_additional_unit_2_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_2');
}

function hmt_widget_additional_unit_3($args) {
	hmt_show_ad('hmt_additional_unit_3', $args);
}

function hmt_widget_additional_unit_3_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_3');
}

function hmt_widget_additional_unit_4($args) {
	hmt_show_ad('hmt_additional_unit_4', $args);
}

function hmt_widget_additional_unit_4_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_4');
}

function hmt_widget_additional_unit_5($args) {
	hmt_show_ad('hmt_additional_unit_5', $args);
}

function hmt_widget_additional_unit_5_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_5');
}

function hmt_widget_additional_unit_6($args) {
	hmt_show_ad('hmt_additional_unit_6', $args);
}

function hmt_widget_additional_unit_6_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_6');
}

function hmt_widget_additional_unit_7($args) {
	hmt_show_ad('hmt_additional_unit_7', $args);
}

function hmt_widget_additional_unit_7_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_7');
}

function hmt_widget_additional_unit_8($args) {
	hmt_show_ad('hmt_additional_unit_8', $args);
}

function hmt_widget_additional_unit_8_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_8');
}

function hmt_widget_additional_unit_9($args) {
	hmt_show_ad('hmt_additional_unit_9', $args);
}

function hmt_widget_additional_unit_9_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_9');
}

function hmt_widget_additional_unit_10($args) {
	hmt_show_ad('hmt_additional_unit_10', $args);
}

function hmt_widget_additional_unit_10_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_10');
}

function hmt_widget_additional_unit_11($args) {
	hmt_show_ad('hmt_additional_unit_11', $args);
}

function hmt_widget_additional_unit_11_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_11');
}

function hmt_widget_additional_unit_12($args) {
	hmt_show_ad('hmt_additional_unit_12', $args);
}

function hmt_widget_additional_unit_12_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_12');
}

function hmt_widget_additional_unit_13($args) {
	hmt_show_ad('hmt_additional_unit_13', $args);
}

function hmt_widget_additional_unit_13_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_13');
}

function hmt_widget_additional_unit_14($args) {
	hmt_show_ad('hmt_additional_unit_14', $args);
}

function hmt_widget_additional_unit_14_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_14');
}

function hmt_widget_additional_unit_15($args) {
	hmt_show_ad('hmt_additional_unit_15', $args);
}

function hmt_widget_additional_unit_15_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_15');
}

function hmt_widget_additional_unit_16($args) {

	hmt_show_ad('hmt_additional_unit_16', $args);
}

function hmt_widget_additional_unit_16_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_16');
}

function hmt_widget_additional_unit_17($args) {
	hmt_show_ad('hmt_additional_unit_17', $args);
}

function hmt_widget_additional_unit_17_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_17');
}

function hmt_widget_additional_unit_18($args) {
	hmt_show_ad('hmt_additional_unit_18', $args);
}

function hmt_widget_additional_unit_18_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_18');
}

function hmt_widget_additional_unit_19($args) {
	hmt_show_ad('hmt_additional_unit_19', $args);
}

function hmt_widget_additional_unit_19_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_19');
}

function hmt_widget_additional_unit_20($args) {
	hmt_show_ad('hmt_additional_unit_20', $args);
}

function hmt_widget_additional_unit_20_controller() {
	hmt_widget_ad_unit_controller('hmt_additional_unit_20');
}

/* HeatMap Theme Footer Functions
-------------------------------------------------------------- */

/* Left Footer
---------------------------------- */

if (!function_exists('hmt_footer_left')):
function hmt_footer_left() {
	$output = hmt4_get_option('hmt_footer_left');
	if ($output!='') 
	{
		echo '<p>'; 
		echo stripslashes($output);
		echo '</p>'; 
	}
}
endif;


/* Right Footer
---------------------------------- */

if (!function_exists('hmt_footer_right')):
function hmt_footer_right() {
	
	$output = hmt4_get_option('hmt_footer_right');
	if ($output!='') 
	{
		echo '<p>'; 
		echo stripslashes($output);
		echo '</p>'; 
	}
}
endif;


/* Left Subfooter
---------------------------------- */

if (!function_exists('hmt_subfooter_left')):
function hmt_subfooter_left() {
	$output = hmt4_get_option('hmt_subfooter_left');
	if ($output!='') 
	{
		echo '<p>'; 
		echo stripslashes($output);
		echo '</p>'; 
	}
}
endif;


/* Right Subfooter
---------------------------------- */

if (!function_exists('hmt_subfooter_right')):
function hmt_subfooter_right() {
		global $heatmap_link;
	$output = hmt4_get_option('hmt_subfooter_right');
	if ($output!='') 
	{
		echo '<p>'; 
		echo stripslashes($output);
		echo '</p>'; 
	}
	else
	{
		echo '<p>WordPress Theme by <a href="'. $heatmap_link .'">HeatMapTheme.com</a></p>';
	}
}
endif;


/* Google Search
(which defaults to wordpress blog search 
if Google Search Code is not configured in the admin) 
---------------------------------- */

if (!function_exists('hmt_google_search')):
function hmt_google_search() {
	$output = hmt4_get_option('hmt_google_search');  	//output the Google Search
	if ($output!='') 
	{
	?>
		<div id="google-search-box">
			<?php echo stripslashes($output); ?>
        </div>
    <?php
	}
	else		
	{
		echo '<form method="get" id="searchform-nav" action="'; echo home_url();    // ...and if you don't have one then the WordPress Search will just have to do
		echo '"><input class="wp-search-text" type="text" value="" name="s" id="s" size="20" />
				<input class="wp-search-submit" type="submit" id="searchsubmit" value="' . __('Search','hmth') . '" />
				</form>';
	}
}
endif;


/* HeatMap Theme Menu Bar Functions
-------------------------------------------------------------- */

function hmt_no_menu() 
{
	echo '<p>'; _e('No Menu Specified!','hmth'); echo '</p>';
}


if (!function_exists('hmt_suckerfish_navbar_v3')):
function hmt_suckerfish_navbar_v3() 
{
	$exclude = hmt4_get_option('hmt_exclude_pages'); 	  // if there pages to be excluded specified in the options then that gets done here 
	echo '<div id="hmt-sf-navbar">' . "\n";
	echo '<ul id="hmt-sf-nav">' . "\n";
	echo '<li><a href="'; echo home_url(); echo '">'. __('Home','hmth') . '</a></li>'; echo "\n";
	$clean_page_list = wp_list_pages('title_li=&depth=4&sort_column=menu_order&exclude=' . $exclude . '&echo=0');  /* remove the titles to stop accidental de-defocus on hover */
    $clean_page_list = preg_replace('/title=\"(.*?)\"/','',$clean_page_list);
    echo $clean_page_list;
	echo '</ul>' . "\n"; 
	echo '</div>' . "\n\n"; 
}
endif;


if (!function_exists('hmt_suckerfish_nav_menubar_v3')):
function hmt_suckerfish_nav_menubar_v3() 
{
	$exclude = hmt4_get_option('hmt_exclude_pages'); 	// if there pages to be excluded specified in the options then that gets done here 
	echo '<div id="hmt-sf-navbar">' . "\n";
	echo '<ul id="hmt-sf-nav">' . "\n";
	$clean_page_list = wp_nav_menu( array('theme_location' => 'primary-menu' ,'echo' => '0',
										  'fallback_cb' => 'hmt_no_menu',
										  'container' => ''));  /* remove the titles to stop accidental de-defocus on hover */
    $clean_page_list = preg_replace('/title=\"(.*?)\"/','',$clean_page_list);
	$position = strpos ($clean_page_list, '>');    // get rid of excess tags from wordpress menu functions
	$clean_page_list = substr_replace($clean_page_list,'',1,$position + 1);
	$clean_page_list = substr_replace($clean_page_list,'',-5,5);
    echo $clean_page_list;
	echo '</ul>' . "\n"; 
	echo '</div>' . "\n\n"; 
}
endif;


if (!function_exists('hmt_suckerfish_catbar_v3')):
function hmt_suckerfish_catbar_v3() 
{
	$exclude = hmt4_get_option('hmt_exclude_categories');
	echo '<div id="hmt-sf-catbar">' . "\n";
	echo '<ul id="hmt-sf-cat">' . "\n";
	$clean_cats = wp_list_categories('title_li=&depth=4&sort_column=menu_order&exclude=' . $exclude . '&echo=0');  /* You wouldnt believe how long it took me to figure out this defocus on hover thing! */
    $clean_cats = preg_replace('/title=\"(.*?)\"/','',$clean_cats);												   /* Thanks for the tip Sam Burdge, for the code that helped me fix this issue http://www.samburdge.co.uk */
	$clean_cats = str_replace('No categories', '', $clean_cats);  /* strip out the 'No Categories' message when there are no categories - to leave just a blank line */
	echo $clean_cats;
	echo '</ul>' . "\n"; 
	echo '</div>' . "\n\n"; 
}
endif;


if (!function_exists('hmt_suckerfish_cat_menubar_v3')):
function hmt_suckerfish_cat_menubar_v3() 
{
	$exclude = hmt4_get_option('hmt_exclude_pages'); 	// if there pages to be excluded specified in the options then that gets done here 
	echo '<div id="hmt-sf-catbar">' . "\n";
	echo '<ul id="hmt-sf-cat">' . "\n";
	$clean_page_list = wp_nav_menu( array('theme_location' => 'secondary-menu' ,
										  'echo' => '0', 'fallback_cb' => 'hmt_no_menu',
										  'container' => ''
										  ));   /* remove the titles to stop accidental de-defocus on hover */
    $clean_page_list = preg_replace('/title=\"(.*?)\"/','',$clean_page_list);
	$position = strpos ($clean_page_list, '>');    // get rid of excess tags from wordpress menu functions
	$clean_page_list = substr_replace($clean_page_list,'',1,$position + 1);
	$clean_page_list = substr_replace($clean_page_list,'',-5,5);
    echo $clean_page_list;
	echo '</ul>' . "\n"; 
	echo '</div>' . "\n\n"; 
}
endif;


/* Check for static widgets in widget-ready areas
- thanks to Chaos Kaizer and Ian Stewart (themeshaper.com) for this function which makes the sidbar validation much neater!
---------------------------------- */

function hmt_is_sidebar_active($index){
	
	global $wp_registered_sidebars;
	$widgetcolums = wp_get_sidebars_widgets();
	if (isset($widgetcolums[$index]) && $widgetcolums[$index]) return true;
	return false;
} 


/* Change length of auto excerpts
-----------------------------------------*/

function new_excerpt_length($hmt_length) {
	$this_excerpt_length = hmt4_get_option('hmt_auto_excerpt_length');
   	return $this_excerpt_length;
}


/* Remove More Link Jump
-----------------------------------------*/
function remove_more_jump_link($link) { 
	$offset = strpos($link, '#more-');
	if ($offset) {
		$end = strpos($link, '"',$offset);
	}
	if ($end) {
		$link = substr_replace($link, '', $offset, $end-$offset);
	}
	return $link;
}

/* Dashboard and RSS
-----------------------------------------*/

function hmt_dashboard_setup_function() {
    add_meta_box( 'hmt4_dashboard_widget', 'HeatMap Theme Latest News', 'hmt4_dashboard_widget_function', 'dashboard', 'side', 'high' );
}


function hmt4_dashboard_widget_function() {
	global $heatmap_link;
	include_once(ABSPATH . WPINC . '/class-simplepie.php');
	$feed = $heatmap_link . '/feed';
	$rss = fetch_feed($feed);
	
	print'<a href="http://heatmaptheme.com"><img src="';
	echo get_template_directory_uri();
	print '/images/preset-images/heatmap-v4-admin-logo-2.png" class="img_valign"  width="144" height="100" style="float:right;" /></a>';

	if (!is_wp_error( $rss ) ) :
		$maxitems = $rss->get_item_quantity(3);
		$rss_items = $rss->get_items(0, $maxitems);
		if ($rss_items):
			echo "<ul>\n";
			foreach ( $rss_items as $item ) :
				echo '<li>';
				echo '<a href="' . $item->get_permalink() . '"  class="rsswidget" target="_blank">' . $item->get_title() . "</a>\n";
			endforeach;
			echo "</ul>\n";
		endif;
	endif;
	hmt4_dashboard_links();
}

function hmt4_dashboard_links() { 
	global $heatmap_link;
?>
    <p>
    	<a href="<?php echo $heatmap_link; ?>/newsletter-subscribe" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/images/hmt-point-newsletter.png" class="img_valign" /></a>&nbsp;<strong><a href="<?php echo $heatmap_link; ?>/newsletter-subscribe" target="_blank">Email Newsletter</a></strong>&nbsp;&nbsp;
		<a href="<?php echo 'http://twitter.com'; ?>/heatmaptheme" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/images/hmt-point-twitter.png" class="img_valign"  /></a>&nbsp;<strong><a href="<?php echo 'http://twitter.com'; ?>/heatmaptheme" target="_blank">Twitter</a></strong>&nbsp;&nbsp;
		<a href="<?php echo $heatmap_link; ?>/hmt-rss-feed" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/images/hmt-point-rss.png" class="img_valign"  /></a>&nbsp;<strong><a href="<?php echo $heatmap_link; ?>/hmt-rss-feed" target="_blank">RSS</a></strong>
    </p>	
<?php
}


function hmt4_rss() {
	global $heatmap_link;
	include_once(ABSPATH . WPINC . '/class-simplepie.php');
	$feed = $heatmap_link . '/feed';
	$rss = fetch_feed($feed);
	if (!is_wp_error( $rss ) ) :
		$maxitems = $rss->get_item_quantity(3);
		$rss_items = $rss->get_items(0, $maxitems);
		if ($rss_items):
			echo "<ul>\n";
			foreach ( $rss_items as $item ) :
				echo '<li>';
				echo '<a href="' . $item->get_permalink() . '"  class="rsswidget" target="_blank">' . $item->get_title() . "</a>\n";
			endforeach;
			echo "</ul>\n";
		endif;
	endif;
	hmt4_dashboard_links();
}


/* get id by slug
-----------------------------------------*/

function hmt_get_id_by_slug($page_slug) {
    $page = get_page_by_path($page_slug);
    if ($page) {
        return $page->ID;
    } else {
        return null;
    }
}


/* Check where a css file exists in child theme
-----------------------------------------*/

function hmt_template_path ($this_file) {
	
	$stylesheetfile = STYLESHEETPATH . '/' . $this_file; 
	if (function_exists('hmt_child_theme') && (file_exists($stylesheetfile)))
		$this_template_path = get_stylesheet_directory_uri() . '/' . $this_file;
	else 
		$this_template_path =  get_template_directory_uri() . '/' . $this_file;

	return $this_template_path;	
}


/* Check if an include file exists in child theme
-----------------------------------------*/

function hmt_include_path ($this_file) {
	
	$includefile = STYLESHEETPATH . '/' . $this_file; 
	if (function_exists('hmt_child_theme') && (file_exists($includefile)))
		$this_include_path = STYLESHEETPATH . '/' . $this_file;
	else 
		$this_include_path =  TEMPLATEPATH . '/' . $this_file;

	return $this_include_path;	
}


/* Register Menus
-------------------------------------------------------------- */

function hmt_register_menus() {

	if (function_exists('register_nav_menus')) {
		register_nav_menus(
			array(
				'primary-menu' =>  __('Page Navigation','hmth') ,
				'secondary-menu' =>  __('Categories Navigation','hmth') 
			)
		);
	}
}



/* Save any Options and Add Theme pages to the Admin
-------------------------------------------------------------- */

function hmt_add_admin() {
 
	global $themename, $shortname, $options, $hmt_theme_init, $heatmap_link;
	 
	if ( isset($_POST['action']) && $_POST['action'] == 'save-ads'  && wp_verify_nonce( $_POST['htm_noncename'], 'heatmaptheme' ) ) {	  // Okay, someone has pressed the save button in the Options page

		foreach ($options as $value) {						// Loop through the options array and write settings to options table
			if($value['type'] == 'ad-combo'){								
				isset($_POST[ $value['id'] ]) ?	$post_value= $_POST[ $value['id'] ] :	$post_value= "";
				isset($_POST[  $value['id'] . '_name' ]) ?	$post_value_name= $_POST[  $value['id'] . '_name' ] :	$post_value_name="";
			
				hmt4_update_option( $value['id'], $post_value  ); 					// Otherwise update the option...
				hmt4_update_option( $value['id'] .'_name', $post_value_name ); // ..the name of each ad widget
				foreach($value['checkbox'] as $checkbox_name => $checkbox_setting){			// ...and then loop through the array of checkboxes associated with it
					$this_option = $value['id'].'_'.$checkbox_name;
					isset( $_POST[$this_option] ) ?	$post_value_check= $_POST[$this_option] : $post_value_check ="";
					hmt4_update_option($this_option, $post_value_check );			// ... updating the options table as you go.
									
				}
			}
			else if( $value['type'] == 'ad-combo-title' )
			{
				hmt4_update_option( $value['id'], $_POST[ $value['id'] ] ); 
			}
		} 
		
		foreach ($options as $value) {				// do a bit of housekeeping deleting any empty options in the options table
			if($value['type'] == 'ad-combo'){
				if ($_POST[ $value['id']]=='') hmt4_delete_option( $value['id'] ); 
				if ($_POST[ $value['id'] .'_name' ] =='') hmt4_delete_option( $value['id'] .'_name'); 
				foreach($value['checkbox'] as $checkbox_name => $checkbox_setting){
					$this_option = $value['id'].'_'.$checkbox_name;						
					if ( !isset($_POST[$this_option ]) || $_POST[$this_option ] == '') hmt4_delete_option( $this_option ); 
				}
			}
		}
		
		hmt4_write_options();
		header("Location: themes.php?page=hmt-options-ads&saved=true");
		die;
	} 
	
	if( isset($_POST['action']) && $_POST['action'] == 'reset-ads' ) {

		foreach ($options as $value) {		// If someone has pressed the Reset button then loop through and delete all the options for this theme
			if($value['type'] == 'ad-combo'){
				hmt4_delete_option( $value['id'] );
				hmt4_delete_option( $value['id'] .'_name');
				foreach($value['checkbox'] as $checkbox_name => $checkbox_setting){     //...including all the check boxes for each ad
					$delete_this_option = $value['id'].'_'.$checkbox_name;
					hmt4_delete_option($delete_this_option);
				}
			}
			else if($value['type'] == "ad-combo-title")
			{
				hmt4_delete_option( $value['id'] );
			}
		}
		hmt4_write_options();
		header("Location: themes.php?page=hmt-options-ads&reset=true");
		die;
	} 
	

	if ( isset($_POST['action']) &&  $_POST['action'] == 'save-options' && wp_verify_nonce( $_POST['htm_noncename'], 'heatmaptheme' ) ) {	  // Okay, someone has pressed the save button in the Options page

//Added by Ankur Sharma
if(isset($_POST['hmt_exclude_pages']))
{
	$_POST['hmt_exclude_pages']= (string) implode("," , ( array ) $_POST['hmt_exclude_pages'] );
}
if( isset($_POST['hmt_exclude_categories']) )
{
	$_POST['hmt_exclude_categories']= (string) implode("," , ( array ) $_POST['hmt_exclude_categories'] );
}
if( isset($_POST['hmt_include_cat_home_post']) )
{
	$_POST['hmt_include_cat_home_post']= (string) implode("," , ( array ) $_POST['hmt_include_cat_home_post'] );
}
if( isset($_POST['hmt_recent_posts_include_cat']) )
{
	$_POST['hmt_recent_posts_include_cat']= (string) implode("," , ( array ) $_POST['hmt_recent_posts_include_cat'] );
}

$logopath="";
if ((($_FILES["logo_img7"]["type"] == "image/gif")
|| ($_FILES["logo_img7"]["type"] == "image/jpeg")
|| ($_FILES["logo_img7"]["type"] == "image/png")
|| ($_FILES["logo_img7"]["type"] == "image/jpeg")
|| ($_FILES["logo_img7"]["type"] == "image/pjpeg"))
&& ($_FILES["logo_img7"]["size"] > 0) &&  ($_FILES["logo_img7"]["error"] == 0))
  {
	  $path7 = wp_upload_dir();
	  if( !file_exists(  $path7['path'] ) )
	  {
			mkdir(  $path7['path'] );  
	  }
		$logopath=  $path7['path'] . "/" . $_FILES["logo_img7"]["name"];
	  if( file_exists(  $logopath ) )
	  {
			unlink( $logopath); 
	  }


      move_uploaded_file( $_FILES["logo_img7"]["tmp_name"],  $logopath);
	  $_POST['hmt_logo_url'] =  $path7['url'] . "/" . $_FILES["logo_img7"]["name"] ;
  }
  
$fevipath="";
if ((($_FILES["fevi_img7"]["type"] == "image/gif")
|| ($_FILES["fevi_img7"]["type"] == "image/jpeg")
|| ($_FILES["fevi_img7"]["type"] == "image/png")
|| ($_FILES["fevi_img7"]["type"] == "image/jpeg")
|| ($_FILES["fevi_img7"]["type"] == "image/pjpeg"))
&& ($_FILES["fevi_img7"]["size"] > 0) &&  ($_FILES["fevi_img7"]["error"] == 0))
  {
	  $path7 = wp_upload_dir();
	  if( !file_exists(  $path7['path'] ) )
	  {
			mkdir(  $path7['path'] );  
	  }
	  $fevipath=  $path7['path'] . "/" .  $_FILES["fevi_img7"]["name"];
	  if( file_exists( $fevipath ) )
	  {
			unlink( $fevipath ); 
	  }

      move_uploaded_file( $_FILES["fevi_img7"]["tmp_name"] , $fevipath);
	  $_POST['hmt_favicon_url'] =     $path7['url'] . "/" . $_FILES["fevi_img7"]["name"];
  }


//End

		foreach ($options as $value) {														// Loop through the options array and write settings to options table
			if($value['type'] != 'ad-combo'  && $value['type'] != 'exclude-from-options' ){								
				if(isset($value['id']))
				{
					isset( $_POST[ $value['id'] ]) ?	$post_value = $_POST[ $value['id'] ] :	$post_value = "";							
					hmt4_update_option( $value['id'], $post_value ); 
				}					// if its not an ad combo then just update the options table
			}
		} 

		foreach ($options as $value) {														// do a bit of housekeeping deleting any empty options in the options table
			if($value['type'] != 'ad-combo'  && $value['type'] != 'exclude-from-options' ){
				if (  isset($value['id']) ){
					if (  !isset($_POST[ $value['id']])  || $_POST[$value['id']]=='') hmt4_delete_option( $value['id'] );  
				}
			}
		}
		hmt4_write_options();
		header("Location: themes.php?page=hmt-options-theme&saved=true#home");
		die;
	} 
	
	
	if( isset($_POST['action']) && $_POST['action'] == 'reset-options') {

		foreach ($options as $value) {				// If someone has pressed the Reset button then loop through and delete all the options for this theme
			if($value['type'] != 'ad-combo' && $value['type'] != 'ad-combo-title' && $value['type'] != 'exclude-from-options' ){
				if(isset($value['id']) ){
					hmt4_delete_option( $value['id'] );
				}

			}
		}
		hmt4_delete_option( 'hmt_import_pre31_ok' );
		hmt4_delete_option( 'hmt_ignore_options' );

		hmt4_write_options();

		header("Location: themes.php?page=hmt-options-theme&reset=true");
		die;
	} 
	
	
	if( isset($_POST['action']) &&  $_POST['action'] == 'import-options' ) {
		
		foreach ($options as $value) { // copy the options
				
			if($value['type'] == 'ad-combo'){	
										
				$this_value = hmt_get_option($value['id']); 
				$hmt_theme_init[$value['id']] = $this_value;
				
				$this_value = hmt_get_option($value['id'] . '_name');
				$hmt_theme_init[$value['id'] . '_name'] = $this_value;
				
				foreach($value['checkbox'] as $checkbox_name => $checkbox_setting){			// ...and then loop through the array of checkboxes associated with it
					$this_option = $value['id'].'_'.$checkbox_name;
					$this_value = hmt_get_option($this_option);
					$hmt_theme_init[$value['id'].'_'.$checkbox_name] = $this_value; 				
				}
			}
			else if ($value['id']) {
				$this_value = hmt_get_option($value['id']);
				$hmt_theme_init[$value['id']] = $this_value;
			}
		}
		
		$hmt_theme_init['hmt_import_pre31_ok'] = true;
		delete_option('hmt_theme_settings');
		add_option ('hmt_theme_settings', $hmt_theme_init);

		header("Location: themes.php?page=hmt-options-theme&imported=true");
		die;
	} 
	
	
	if( isset($_POST['action']) &&  $_POST['action'] == 'delete-options' ) {
		
		foreach ($options as $value) {			// delete the options
			
			if($value['type'] == 'ad-combo'){
				delete_option( $value['id'] ); 
				delete_option( $value['id'] .'_name'); 
				foreach($value['checkbox'] as $checkbox_name => $checkbox_setting){
					$this_option = $value['id'].'_'.$checkbox_name;						
					delete_option( $this_option ); 
				}
			}
			else
			{
				delete_option($value['id']);
			}
		}
		header("Location: themes.php?page=hmt-options-theme&deleted-old-options=true");
		die;
	}
	
	
	if(  isset($_POST['action']) &&  $_POST['action'] == 'ignore-options' ) {
		hmt4_update_option('hmt_ignore_options', true);
		hmt4_write_options();
		header("Location: themes.php?page=hmt-options-theme&ignore-options=true");
		die;
	}
	
	$page1=add_theme_page(__('HeatMap Options', 'hmth'), __('HeatMap Options', 'hmth'), "edit_theme_options", 'hmt-options-theme', 'hmt_theme_options');
	$page2=add_theme_page(__('HeatMap Ads', 'hmth'), __('HeatMap Ads', 'hmth'), "edit_theme_options", 'hmt-options-ads', 'hmt_ads_options');		
	add_action("admin_head-$page1",  'hmt_add_to_optionpage_head', 50);
	add_action("admin_head-$page2",  'hmt_add_to_adpage_head', 50);
}


/* Ad Options
-------------------------------------------------------------- */

function hmt_ads_options() { 

	global $themename, $shortname, $options, $baseversion, $thisversion, $subtitle, $heatmap_link;
			 
	?>
    
	<div class="wrap">
        
		<h2><img src="<?php echo get_template_directory_uri(); ?>/images/preset-images/heatmap-v4-admin-logo.png" class="img_valign"  width="47" height="45" />&nbsp;<?php echo $themename ?>&nbsp;<?php _e('Ads','hmth'); ?>&nbsp;&nbsp;&nbsp;&nbsp;&raquo;<?php _e('Visit the','hmth'); ?> <a href="<?php echo $heatmap_link; ?>/forum-login" target="_blank"><?php _e('HeatMap Theme Forum','hmth'); ?></a> <?php _e('and','hmth'); ?> <a href="<?php echo $heatmap_link; ?>/version-5" target="_blank"><?php _e('User Guide','hmth'); ?></a></h2>
	
		<?php
        if ( isset( $_REQUEST['saved'] ) && $_REQUEST['saved'] ) {
            echo '<div id="message" class="updated fade"><p><strong>';
            echo $themename;
            _e(' Ad settings saved.','hmth');
            echo '</strong></p></div>';
        }
        
        if ( isset($_REQUEST['reset']) && $_REQUEST['reset'] ) {
            echo '<div id="message" class="updated fade"><p><strong>';
            echo $themename;
            _e(' Ad settings reset.','hmth');
            echo '</strong></p></div>';
        }	
        ?>
        
		<div style="width:1065px;  margin-top: 10px;"> 
    

        	<script type="text/javascript">


        		function toggle_fun2(name)
        		{
        			jQuery('#'+name+'_7').slideToggle(0); 
        			if(jQuery('#'+name).val() == '1')
        			{ 
        				jQuery('#'+name).val('0');
        			} else { 
        				jQuery('#'+name).val('1');
        			}
        			 return false;
        		}
        	</script>
        
  	
			<div  class="hmt-admin-wrap"  style="float:left">
			<form method="post" action="">
					
				<?php 
				foreach ($options as $value) {			// Loop through the options array and display all the options in a form for editing.
					switch ( $value['type'] ) {			
			
/* This is the left column of the options page
-------------------------------------------------------------- */

/* Open
-------------------------------------------------------------- */	
	
					case "ad-combo-open": ?>
						<table class="widefat"  cellspacing="0" style="width:700px;">
			 
					<?php break;
				 
/* Close
-------------------------------------------------------------- */	
				 
					case "ad-combo-close": ?>

					<tr>
					<td><input name="save" type="submit" value="<?php _e('Save','hmth'); ?>" class="button-primary"/></td>
					</tr>
						</tbody></table>
						<br />
					<?php break;
	
/* Title
-------------------------------------------------------------- */	
				 
					case "ad-combo-title": ?>
						                    	
                        <thead  onclick="toggle_fun2('<?php echo $value['id']; ?>')"> 
							<tr>
								<th colspan="2" scope="col">
									<?php echo $value['name']; ?> 
									<div style="float:right">
                                    	
										
										<input type="hidden" name="action" value="save-ads" />
										
									</div>
								</th>
							</tr>
						</thead>
						<tbody id="<?php echo $value['id'];  ?>_7" <?php if( ! hmt4_get_option( $value['id'] ) ){ echo 'style="display:none;"'; }  ?>  >
						<tr><td><input type="hidden"  value="<?php echo hmt4_get_option( $value['id'] );  ?>" name="<?php echo $value['id'];  ?>" id="<?php echo $value['id'];  ?>" /></td></tr>
					<?php break;

						
/* Ad Combo box
-------------------------------------------------------------- */	
	
					case 'ad-combo': ?> 
						<tr>
							<td width="350">
							

							<input style="width:200px; font-size:11px; font-weight:bold;" name="<?php echo $value['id'] .'_name'; ?>" id="<?php echo $value['id']  .'_name'; ?>" type="text" value="<?php 
							if ( hmt4_get_option( $value['id'] . '_name') != "") 
								{ echo hmt4_get_option( $value['id'] . '_name'); } 
								else { echo $value['name']; } ?>" /><small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br />
							
								<?php 
								$this_key = $value['id'] . '_' . 'Home'; 
								$this_setting = hmt4_get_option($this_key); 
								if ($this_setting == '') $checked = "";
								else $checked = "checked=\"checked\""; 
								?>
								<input type="checkbox" name="<?php echo $this_key; ?>" id="<?php echo $this_key; ?>" value="true" <?php echo $checked; ?> /> <label for="<?php echo $this_key; ?>"><?php _e('Home','hmth'); ?></label><br />

								<?php 
								$this_key = $value['id'] . '_' . 'Page'; 
								$this_setting = hmt4_get_option($this_key); 
								if ($this_setting == '') $checked = "";
								else $checked = "checked=\"checked\""; 
								?>
								<input type="checkbox" name="<?php echo $this_key; ?>" id="<?php echo $this_key; ?>" value="true" <?php echo $checked; ?> /> <label for="<?php echo $this_key; ?>"><?php _e('Page','hmth'); ?></label><br />

								<?php 
								$this_key = $value['id'] . '_' . 'Post'; 
								$this_setting = hmt4_get_option($this_key); 
								if ($this_setting == '') $checked = "";
								else $checked = "checked=\"checked\""; 
								?>
								<input type="checkbox" name="<?php echo $this_key; ?>" id="<?php echo $this_key; ?>" value="true" <?php echo $checked; ?> /> <label for="<?php echo $this_key; ?>"><?php _e('Post','hmth'); ?></label><br />

								<?php 
								$this_key = $value['id'] . '_' . 'Category'; 
								$this_setting = hmt4_get_option($this_key);
								if ($this_setting == '') $checked = "";
								else $checked = "checked=\"checked\"";  
								?>
								<input type="checkbox" name="<?php echo $this_key; ?>" id="<?php echo $this_key; ?>" value="true" <?php echo $checked; ?> /> <label for="<?php echo $this_key; ?>"><?php _e('Category','hmth'); ?></label><br />

								<?php 
								$this_key = $value['id'] . '_' . 'Search'; 
								$this_setting = hmt4_get_option($this_key); 
								if ($this_setting == '') $checked = "";
								else $checked = "checked=\"checked\"";  
								?>
								<input type="checkbox" name="<?php echo $this_key; ?>" id="<?php echo $this_key; ?>" value="true" <?php echo $checked; ?> /> <label for="<?php echo $this_key; ?>"><?php _e('Search','hmth'); ?></label><br />
								
								<?php 
								$this_key = $value['id'] . '_' . 'Archive'; 
								$this_setting = hmt4_get_option($this_key); 
								if ($this_setting == '') $checked = "";
								else $checked = "checked=\"checked\"";  
								?>
								<input type="checkbox" name="<?php echo $this_key; ?>" id="<?php echo $this_key; ?>" value="true" <?php echo $checked; ?> /> <label for="<?php echo $this_key; ?>"><?php _e('Archive','hmth');; ?></label><br />

								
							</td>
							<td width="350">
							
							<textarea name="<?php echo $value['id']; ?>" style="width:340px; height:120px; font-size:11px;" ><?php if ( hmt4_get_option( $value['id'] ) != "") { echo htmlspecialchars(hmt4_get_option( $value['id'])); } else { echo $value['std']; } ?></textarea>
							</td> 
						</tr>
						
					<?php break;
				 
					}
				}
				?>
	
<?php			
/* Submit and Reset Buttons
-------------------------------------------------------------- */
?>
			 
				<p class="submit">
					<input name="save" type="submit" value="<?php _e('Save changes','hmth'); ?>" class="button-primary"/>
					<input type="hidden" name="action" value="save-ads" />
					<input type="hidden" name="htm_noncename" value="<?php echo wp_create_nonce('heatmaptheme'); ?>" />
				</p>
			</form>
			
			<form action="" method="post">
				<p class="submit">
				<input name="reset" type="submit" value="<?php _e('Reset HeatMap Theme Ads','hmth'); ?>" class="button-secondary" />
				<input type="hidden" name="action" value="reset-ads" />
			</p>
			</form>
			
			</div>
			
			<?php right_options_column(); ?>				
		
		</div>
	</div>
<?php
}


/* Theme Options
-------------------------------------------------------------- */

function hmt_theme_options() {
 
	global $themename, $shortname, $options, $baseversion, $thisversion, $subtitle, $hmt_current_options, $heatmap_link; ?>
			 
	<div class="wrap">
		<h2><img src="<?php echo get_template_directory_uri(); ?>/images/preset-images/heatmap-v4-admin-logo.png" class="img_valign" width="47" height="45" />&nbsp;<?php echo $themename ?>&nbsp;<?php _e('Options','hmth'); ?>&nbsp;&nbsp;&nbsp;&nbsp;&raquo;<?php _e('Visit the','hmth'); ?> <a href="<?php echo $heatmap_link; ?>/forum-login" target="_blank"><?php _e('HeatMap Theme Forum','hmth'); ?></a> <?php _e('and','hmth'); ?> <a href="<?php echo $heatmap_link; ?>/version-5" target="_blank"><?php _e('User Guide','hmth'); ?></a></h2>
	
		<?php
        if ( isset($_REQUEST['saved']) && $_REQUEST['saved'] ) {
            echo '<div id="message" class="updated fade"><p><strong>';
            echo $themename;
            _e(' Theme settings saved.','hmth');
            echo '</strong></p></div>';
        }
        
        if ( isset($_REQUEST['reset']) && $_REQUEST['reset'] ) {
            echo '<div id="message" class="updated fade"><p><strong>';
            echo $themename;
            _e(' Theme settings reset.','hmth');
            echo '</strong></p></div>';
        }
		
		
		if ( isset($_REQUEST['imported']) && $_REQUEST['imported'] ) {
            echo '<div id="message" class="updated fade"><p><strong>';
            _e('Options imported.','hmth');
            echo '</strong></p></div>';
        }
		
		if ( isset($_REQUEST['deleted-old-options']) && $_REQUEST['deleted-old-options'] ) {
            echo '<div id="message" class="updated fade"><p><strong>';
            _e('Old database settings deleted.','hmth');
            echo '</strong></p></div>';
        }
		
		
		if ( isset($_REQUEST['ignore-options']) && $_REQUEST['ignore-options'] ) {
            echo '<div id="message" class="updated fade"><p><strong>';
            _e('The old options message has now vanished!','hmth');
            echo '</strong></p></div>';
        }
                 
        /* If this is an old version of Wordpress show a warning - styled inline 'just in case' so that the message will be seen - dont want to take any chances! -added 24/03/10  */
        if (get_bloginfo('version') < 3) { 
            print '<div style="background-color:#fff; color:#000; padding: 5px;">';
            print '<p style="margin-bottom: 3px;"><strong>' . _e('HeatMap Theme requires WordPress version 3 upwards','hmth') . '</strong> - ' . _e('You are currently running','hmth') . "&nbsp;";
            print bloginfo('version');
            print '<br /><small>' . _e('Please note some plugins block Heatmap Theme from knowing what the WP version number is so you might get this message even though your WP install is up to date!','hmth') . '</small></p>';
            
            print '</div>';
        }
        
        // check to see if there are any options lurking around from v3.0.5b or older
        
        $old_options_hanging_around = false;
        
        foreach ($options as $value) {
            if ( isset($value['id']) && $value['id']) {
                if (hmt_get_option($value['id'])) $old_options_hanging_around = true;
            }
        }
        
		if (!hmt4_get_option('hmt_ignore_options')) {
			if (($old_options_hanging_around) && (!hmt4_get_option('hmt_import_pre31_ok'))) { ?>
				<div id="message" class="updated fade">
                    <p><strong><?php _e('Option settings and ad settings from an older version of HeatMap Theme have been found','hmth');?>.</strong></p>
                    <p><?php _e('Would you like to import these settings now?','hmth'); ?></p>
                    
                    <form method="post" action="">
                        <p class="submit"> 
                        <input name="import-options" type="submit" value="<?php _e('Yes, Import the options','hmth'); ?>" class="button-secondary" />
                        <input type="hidden" name="action" value="import-options" />
                        <?php _e("I'm not sure...",'hmth'); ?>
                        <strong>
                        <a href="<?php echo $heatmap_link; ?>/version-5/import-options/">
                        <?php _e('Help!','hmth'); ?>
                        </a>
                        </strong>	
                        </p>
                    </form>
                    
                    <form method="post" action="">
                        <p class="submit"> 
                        <input name="import-options" type="submit" value="<?php _e('Nope, just make this message go away','hmth'); ?>" class="button-secondary" />
                        <input type="hidden" name="action" value="ignore-options" />
                        </p>
                    </form>
				</div>
				
			<?php
			}
		}
		
		if (!hmt4_get_option('hmt_ignore_options')) {
			if (($old_options_hanging_around) && (hmt4_get_option('hmt_import_pre31_ok'))) { ?>
				<div id="message" class="updated fade">
                    <p><strong><?php _e('There are currently old HeatMap Theme option settings and ad settings in the options database. Would you like to tidy them up?','hmth');?></strong></p>
                    <p><?php _e('You can safely delete them if you intend never to use an older version of HeatMap Theme again.','hmth'); ?></p>
                    
                    <form method="post" action="">
                        <p class="submit"> 
                        <input name="delete-options" type="submit" value="<?php _e('Yes, delete the old database settings','hmth'); ?>" class="button-secondary" />
                        <input type="hidden" name="action" value="delete-options" />
                        <?php _e("I'm not sure...",'hmth'); ?>
                        <strong>
                        <a href="<?php echo $heatmap_link; ?>/version-5/delete-options/">
                        <?php _e('Help!','hmth'); ?>
                        </a>
                        </strong>	
                        </p>
                    </form>
                    
                    <form method="post" action="">
                        <p class="submit"> 
                            <input name="import-options" type="submit" value="<?php _e('No. Please make this message dissapear','hmth'); ?>" class="button-secondary" />
                            <input type="hidden" name="action" value="ignore-options" />	
                        </p>
                    </form>
                
                
				</div>
				
			<?php
			}
		}
		?>   
	
		<div style="width:1065px;  margin-top: 10px;"> 

        	<script type="text/javascript">
        		function toggle_fun(name)
        		{
        			jQuery('#'+name+'_7').slideToggle(0); 
        			if(jQuery('#'+name).val() == '1')
        			{ 
        				jQuery('#'+name).val('0');
        			} else { 
        				jQuery('#'+name).val('1');
        			}
        			 return false;
        		}
        	</script>
        
    
			<div class="hmt-admin-wrap" style="float:left">
			<form method="post" enctype="multipart/form-data" action="">

				<?php 

				foreach ($options as $value) {			// Loop through the options array and display all the options in a form for editing.
					switch ( $value['type'] ) {			
			
/* This is the left column of the options page
-------------------------------------------------------------- */

/* Open
-------------------------------------------------------------- */	
	
					case "open": ?>

						<table class="widefat" cellspacing="0" style="width:700px;">
			 
					<?php break;
	
				 
/* Close
-------------------------------------------------------------- */	
				 
					case "close": ?>
					<tr>
					<td><input name="save" type="submit" value="<?php _e('Save','hmth'); ?>" class="button-primary"/></td>
					</tr>
						</tbody></table>
						<br />
					<?php break;
	
	
/* Title
-------------------------------------------------------------- */	
				 
					case "title": ?>
                    	                    	
						<thead onclick="toggle_fun('<?php echo $value['id']; ?>')" >
							<tr>
								<th colspan="2" scope="col">
									<?php echo $value['name']; ?>
									<div style="float:right">
                                    	
										
										<input type="hidden" name="action" value="save-options" />
										<input type="hidden" name="htm_noncename" value="<?php echo wp_create_nonce('heatmaptheme'); ?>" />
									</div>
								</th>
							</tr>
						</thead>
						<tbody id="<?php echo $value['id'];  ?>_7" <?php if( ! hmt4_get_option( $value['id'] ) ){ echo 'style="display:none;"'; }  ?>  >
						<tr><td><input type="hidden"  value="<?php echo hmt4_get_option( $value['id'] );  ?>" name="<?php echo $value['id'];  ?>" id="<?php echo $value['id'];  ?>" /></td></tr>
					<?php break;


/* Text
-------------------------------------------------------------- */
					
					case 'text': ?>

					<?php  if( $value['id'] == 'hmt_featured' )
						{ ?> 
						<tr>
							<td width="350"><?php echo $value['name']; ?>
								<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong> </a> </small><br /><br />
								<?php echo $value['desc']; ?>
							</td>
							<td width="350">
							<select style="width:340px; font-size:11px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" > 
				<?php
							echo "<option value=''>Select</option>";
							$allpages = get_pages(  );
							foreach( $allpages as $singlepage )
							{
								echo "<option value='" . $singlepage->ID . "'";
								if( $singlepage->ID == htmlspecialchars(stripslashes(hmt4_get_option( $value['id']))))
								{
									echo " selected='selected' ";
								}
								echo " >" .  $singlepage->post_title . "</option>";
							}
							
				?></select></td></tr>
                			

				<?php		}
						else if( $value['id'] == 'hmt_exclude_pages'  )
						{
?>
<script type="text/javascript">

function selectAll(selObj)
{

for (i = 0; i < selObj.options.length; i ++)
{
selObj.options[i].selected = false;
}
}

function deselect_others(selObj)
{
	for (i = 1; i < selObj.options.length; i ++)
	{
		selObj.options[i].selected = false;
	}
}

function check_if_1st_selected(selObj)
{
	if(selObj.options[0].selected==true)
	{
		deselect_others(selObj);
	}
}
</script>
<?php
						  if ( ! has_nav_menu( 'primary-menu') ){ ?> 
						<tr>
							<td width="350"><?php echo $value['name']; ?>
								<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
								<?php echo $value['desc']; ?>
							</td>
							<td width="350">
							<select size="10"  multiple="multiple"  style="width:340px; height:auto; font-size:11px;" name="<?php echo $value['id']; ?>[]" id="<?php echo $value['id']; ?>" > 
				<?php
							//echo "<option value=''>Select</option>";
							$allpages = get_pages(  );
							$currentpages = explode(",", htmlspecialchars(stripslashes(hmt4_get_option( $value['id']))) );

							foreach( $allpages as $singlepage )
							{
								echo "<option value='" . $singlepage->ID . "'";
								if( in_array($singlepage->ID , $currentpages ) )
								{
									echo " selected='selected' ";
								}
								echo " >" .  $singlepage->post_title . "</option>";
							}
							
				?></select>


				<br/> <a href="javascript:void(0)" onclick="selectAll(document.getElementById('hmt_exclude_pages'))"><?php _e('deselect all','hmth'); ?></a></td></tr>

				<?php	}	}
						else if( $value['id'] == 'hmt_exclude_categories'  )
						{  if ( ! has_nav_menu( 'secondary-menu' ) ) { ?> 
						<tr>
							<td width="350"><?php echo $value['name']; ?>
								<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
								<?php echo $value['desc']; ?>
							</td>
							<td width="350">
							<select  multiple="multiple" size="10" style="width:340px; height:auto; font-size:11px;" name="<?php echo $value['id']; ?>[]" id="<?php echo $value['id']; ?>" > 
				<?php
							//echo "<option value=''>Select</option>";
							$allcat = get_categories();
							$currentcat = explode(",", htmlspecialchars(stripslashes(hmt4_get_option( $value['id']))) );

							foreach( $allcat as $singlecat )
							{
								echo "<option value='" . $singlecat->cat_ID . "'";
								if( in_array( $singlecat->cat_ID , $currentcat ) )
								{
									echo " selected='selected' ";
								}
								echo " >" .  $singlecat->cat_name . "</option>";
							}
				?></select>
				<br/> <a href="javascript:void(0)" onclick="selectAll(document.getElementById('hmt_exclude_categories'))"><?php _e('deselect all','hmth'); ?> </a></td></tr>
				<?php	}	}
						else
						{
							?>
						<tr>
							<td width="350"><?php echo $value['name']; ?>
								<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp; </strong></a></small><br /><br />
								<?php echo $value['desc']; ?>
							</td>
							<td width="350">

								<input style="width:340px; font-size:11px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="text" value="<?php if ( hmt4_get_option( $value['id'] ) != "") { echo htmlspecialchars(stripslashes(hmt4_get_option( $value['id']))); } else { echo $value['std']; } ?>" />
                                <?php  //Added By Ankur Sharma
									if( $value['id'] == 'hmt_logo_url' )
									{
										?>
                                        	<br />
                                            <input type="file" name="logo_img7"  id="logo_img7" />
                                        <?php	
									}
									else if( $value['id'] == 'hmt_favicon_url' )
									{
										?>
                                        	<br />
                                            <input type="file" name="fevi_img7"  id="fevi_img7" />
                                        <?php	
									}

							//End	
							?>
							</td>
						</tr>
				<?php	}
				?>
                                

			
					<?php break;

/* Multi select
-------------------------------------------------------------- */
					
					case 'multi-select': ?>

						<tr>
							<td width="350"><?php echo $value['name']; ?>
								<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
								<?php echo $value['desc']; ?>
							</td>
							<td width="350">


<?php		
						 if( $value['id'] == 'hmt_include_cat_home_post' ||  $value['id'] == 'hmt_recent_posts_include_cat' )
						{  ?> 

							<select onChange="check_if_1st_selected(document.getElementById('<?php echo $value['id']; ?>'))"  multiple="multiple" size="10" style="width:340px; height:auto; font-size:11px;" name="<?php echo $value['id']; ?>[]" id="<?php echo $value['id']; ?>" > 
				<?php							
							$allcat = get_categories();
							$current_value=hmt4_get_option( $value['id']);
							$currentcat = explode(",", htmlspecialchars(stripslashes($current_value)) );
							$current_value=trim($current_value);
							if($value['id'] == 'hmt_include_cat_home_post' )
							{
								echo '<option onclick="deselect_others(document.getElementById(\''. $value['id'].'\'))" value=""';
								if($current_value=="" )
								{
									echo " selected='selected' ";
								}
								echo '>Include All</option>';
							}

							foreach( $allcat as $singlecat )
							{
								echo "<option value='" . $singlecat->cat_ID . "'";
								if( in_array( $singlecat->cat_ID , $currentcat ) )
								{
									echo " selected='selected' ";
								}
								echo " >" .  $singlecat->cat_name . "</option>";
							}
							 
				?></select>
				<br/> <a href="javascript:void(0)" onclick="selectAll(document.getElementById('<?php echo $value['id']; ?>'))"><?php _e('deselect all','hmth'); ?></a>
				
<?php } ?>
							</td>
						</tr>

					<?php  break;
					
/* Short Text
-------------------------------------------------------------- */
					
					case 'short-text': ?>
						<tr>
							<td width="350"><?php echo $value['name']; ?>
								<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
								<?php echo $value['desc']; ?>
							</td>
							<td width="350">
								<input style="width:50px; font-size:11px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="text" value="<?php if ( hmt4_get_option( $value['id'] ) != "") { echo htmlspecialchars(stripslashes(hmt4_get_option( $value['id']))); } else { echo $value['std']; } ?>" />
							</td>
						</tr>
			
					<?php break;


					
/* Sub Title
-------------------------------------------------------------- */
					
					case 'suboptions': ?>
						<tr>
							<td width="350"><strong><?php echo $value['name']; ?></strong>
								
							</td>
							<td width="350">
								
							</td>
						</tr>
			
					<?php break;
	
				 
/* Text Area
-------------------------------------------------------------- */	
				 
					case 'textarea': ?> 
<?php if(  !(hmt4_get_option('hmt_seo_plugin') &&  ($value['id'] == 'hmt_meta_description' || $value['id'] =='hmt_meta_keywords'))    ) { ?>
						<tr>
							<td width="350"><?php echo $value['name']; ?>
								<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
								<?php echo $value['desc']; ?>
							</td>
							<td width="350">
							<textarea name="<?php echo $value['id']; ?>" style="width:340px; height:90px; font-size:11px;" ><?php if ( hmt4_get_option( $value['id'] ) != "") { echo htmlspecialchars(hmt4_get_option($value['id'])); } else { echo $value['std']; } ?></textarea>
							</td> 
						</tr>
						<?php } ?>
					<?php break;


/* Text Area Full Width
-------------------------------------------------------------- */	
				 
					case 'textarea-full': ?> 
						<tr>
							<td colspan="2" width="700"><?php echo $value['name']; ?>
								<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br />
								<?php echo $value['desc']; ?>
							
							<textarea name="<?php echo $value['id']; ?>" style="width:680px; height:150px; font-size:11px;" ><?php if ( hmt4_get_option( $value['id'] ) != "") { echo htmlspecialchars(hmt4_get_option($value['id'])); } else { echo $value['std']; } ?></textarea>
							</td> 
						</tr>
						
					<?php break;
	
					
/* Checkbox
-------------------------------------------------------------- */
					
					case 'checkbox': ?>
						<tr>
							<td width="350"><?php echo $value['name']; ?>
								<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
								<?php echo $value['desc']; ?>
							</td>
							<td width="350">
								<?php if( hmt4_get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
								<input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
							</td>
						</tr>
			
					<?php break;
						
	
/* Selection left - right
-------------------------------------------------------------- */

					case 'select-left-right': ?>
						<tr>
							<td width="350"><?php echo $value['name']; ?>
							<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
							<?php echo $value['desc']; ?>
							
							</td>
							
                            <td width="350">
                                <select
                                
                                style="width:100px;"
                                name="<?php echo $value['id']; ?>"
                                id="<?php echo $value['id']; ?>">
                                
                                <option value="LEFT" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "LEFT" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("LEFT",'hmth'); ?>
                                </option>
                                
                                <option value="RIGHT"
                                   <?php if ( hmt4_get_option( $value['id'] ) == "RIGHT" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("RIGHT",'hmth'); ?>
                                </option>  
                                
                                </select>   
                            </td>						
                       	</tr>
					
					<?php
					break;	

/* Selection left - right - off
-------------------------------------------------------------- */

					case 'select-left-right-off': ?>
						<tr>
							<td width="350"><?php echo $value['name']; ?>
							<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
							<?php echo $value['desc']; ?>
							
							</td>
							
                            <td width="350">
                                <select
                                
                                style="width:100px;"
                                name="<?php echo $value['id']; ?>"
                                id="<?php echo $value['id']; ?>">
                                
                                <option value="LEFT" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "LEFT" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("LEFT",'hmth'); ?>
                                </option>
                                
                                <option value="RIGHT"
                                   <?php if ( hmt4_get_option( $value['id'] ) == "RIGHT" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("RIGHT",'hmth'); ?>
                                </option>  
                                
                                <option value="OFF"
                                   <?php if ( hmt4_get_option( $value['id'] ) == "OFF" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("OFF",'hmth'); ?>
                                </option>   
                                
                                </select>   
                            </td>						
                       	</tr>
					
					<?php
					break;	

					
					
/* Selection Header Locking
-------------------------------------------------------------- */

					case 'select-header-lock': ?>
						<tr>
							<td width="350"><?php echo $value['name']; ?>
							<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
							<?php echo $value['desc']; ?>
							
							</td>
							
                            <td width="350">
                                <select
                                
                                style="width:200px;"
                                name="<?php echo $value['id']; ?>"
                                id="<?php echo $value['id']; ?>">
                                
                                <option value="OFF" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "OFF" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("OFF",'hmth'); ?>
                                </option>
                                
                                <option value="[Header] Lock Only" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "[Header] Lock Only" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("[Header] Lock Only",'hmth'); ?>
                                </option>
                                
                                <option value="All Header Bars"
                                   <?php if ( hmt4_get_option( $value['id'] ) == "All Header Bars" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("All Header Bars",'hmth'); ?>
                                </option> 
                                
                                </select>   
                            </td>						
                       	</tr>
					
					<?php
					break;	

					
/* Selection Footer Locking
-------------------------------------------------------------- */

					case 'select-footer-lock': ?>
						<tr>
							<td width="350"><?php echo $value['name']; ?>
							<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
							<?php echo $value['desc']; ?>
							
							</td>
							
                            <td width="350">
                                <select
                                
                                style="width:200px;"
                                name="<?php echo $value['id']; ?>"
                                id="<?php echo $value['id']; ?>">
                                
                                <option value="OFF" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "OFF" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("OFF",'hmth'); ?>
                                </option>
                                
                                <option value="[Sub Footer] Lock Only" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "[Sub Footer] Lock Only" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("[Sub Footer] Lock Only",'hmth'); ?>
                                </option>
                                
                                <option value="All Footer Bars"
                                   <?php if ( hmt4_get_option( $value['id'] ) == "All Footer Bars" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("All Footer Bars",'hmth'); ?>
                                </option> 
                                
                                </select>   
                            </td>						
                       	</tr>
					
					<?php
					break;	


/* Selection Search Social RSS Position
-------------------------------------------------------------- */

					case 'select-search-social-rss-position': ?>
						<tr>
							<td width="350"><?php echo $value['name']; ?>
							<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
							<?php echo $value['desc']; ?>
							
							</td>
							
                            <td width="350">
                                <select
                                
                                style="width:200px;"
                                name="<?php echo $value['id']; ?>"
                                id="<?php echo $value['id']; ?>">
                                
                                <option value="Page Navigation Bar" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "Page Navigation Bar" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("Page Navigation Bar",'hmth'); ?>
                                </option>
                                
                                <option value="Categories Navigation Bar" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "Categories Navigation Bar" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("Categories Navigation Bar",'hmth'); ?>
                                </option>
                                         
                                </select>   
                            </td>						
                       	</tr>
					
					<?php
					break;	
					
		
/* Selection H1 type
-------------------------------------------------------------- */

					case 'select-h1': ?>
						<tr>
							<td width="350"><?php echo $value['name']; ?>
							<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
							<?php echo $value['desc']; ?>
							
							</td>
							
                            <td width="350">
                                <select
                                
                                style="width:150px;"
                                name="<?php echo $value['id']; ?>"
                                id="<?php echo $value['id']; ?>">
                                
                                <option value="FEATURED PAGE" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "FEATURED PAGE" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("FEATURED PAGE",'hmth'); ?>
                                </option>
                                
                                <option value="SITE TITLE"
                                   <?php if ( hmt4_get_option( $value['id'] ) == "SITE TITLE" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("SITE TITLE",'hmth'); ?>
                                </option>    
                                
                                <option value="TAGLINE" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "TAGLINE" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("TAGLINE",'hmth'); ?>
                                </option>
                                
                                <option value="MANUAL SETTING"
                                   <?php if ( hmt4_get_option( $value['id'] ) == "MANUAL SETTING" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("MANUAL SETTING",'hmth'); ?>
                                </option>  
                                
                                </select>   
                            </td>						
                       	</tr>
					
					<?php
					break;

					
/* Selection Number of Post to Show
-------------------------------------------------------------- */

					case 'select-num-posts': ?>
						<tr>
							<td width="350"><?php echo $value['name']; ?>
							<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
							<?php echo $value['desc']; ?>
							
							</td>
							
                            <td width="350">
                                <select
                                
                                style="width:150px;"
                                name="<?php echo $value['id']; ?>"
                                id="<?php echo $value['id']; ?>">
                                
                                <option value="3 Posts" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "3 Posts" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("3 Posts",'hmth'); ?>
                                </option>
                                
                                <option value="4 Posts"
                                   <?php if ( hmt4_get_option( $value['id'] ) == "4 Posts" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("4 Posts",'hmth'); ?>
                                </option>    
                                
                        		<option value="5 Posts"
                                   <?php if ( hmt4_get_option( $value['id'] ) == "5 Posts" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("5 Posts",'hmth'); ?>
                                </option>  
                                
                        		<option value="6 Posts"
                                   <?php if ( hmt4_get_option( $value['id'] ) == "6 Posts" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("6 Posts",'hmth'); ?>
                                </option>  
                                
                              	<option value="7 Posts"
                                   <?php if ( hmt4_get_option( $value['id'] ) == "7 Posts" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("7 Posts",'hmth'); ?>
                                </option> 
                                
                                <option value="8 Posts"
                                   <?php if ( hmt4_get_option( $value['id'] ) == "8 Posts" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("8 Posts",'hmth'); ?>
                                </option>  
                                
                               	<option value="9 Posts"
                                   <?php if ( hmt4_get_option( $value['id'] ) == "9 Posts" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("9 Posts",'hmth'); ?>
                                </option>  
                                
                                <option value="10 Posts"
                                   <?php if ( hmt4_get_option( $value['id'] ) == "10 Posts" ) { echo ' selected="selected"'; } ?>>
                                   <?php _e("10 Posts",'hmth'); ?>
                                </option>  
                               
                                </select>   
                            </td>						
                       	</tr>
					
					<?php
					break;
	
					
/* Nav and Footer Style
-------------------------------------------------------------- */

					case 'select-nav-style': ?>
						<tr>
							<td width="350"><?php echo $value['name']; ?>
							<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
							<?php echo $value['desc']; ?>
							
							</td>
							
                            <td width="350">
                                <select
                                
                                style="width:200px;"
                                name="<?php echo $value['id']; ?>"
                                id="<?php echo $value['id']; ?>">
                                
                                <option value="Classic" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "Classic" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("Classic",'hmth'); ?>
                                </option>
                                
 								<option value="Below Header" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "Below Header" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("Below Header",'hmth'); ?>
                                </option>  
                                
                                <option value="Above Header" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "Above Header" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("Above Header",'hmth'); ?>
                                </option>
                                
                                <option value="Wide" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "Wide" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("Wide",'hmth'); ?>
                                </option>    
                                
                                </select>   
                            </td>						
                       	</tr>
					
					<?php
					break;	
					
					
/* Home page posts and sidebar style
-------------------------------------------------------------- */

					case 'select-posts-sidebar-style': ?>
						<tr>
							<td width="350"><?php echo $value['name']; ?>
							<small><a href="<?php echo $heatmap_link; ?>version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
							<?php echo $value['desc']; ?>
							
							</td>
							
                            <td width="350">
                                <select
                                
                                style="width:200px;"
                                name="<?php echo $value['id']; ?>"
                                id="<?php echo $value['id']; ?>">
                                
                                
                               <option value="Not Hidden" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "Not Hidden" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("Not Hidden",'hmth'); ?>
                                </option>
                                
                                <option value="Hide Posts Only" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "Hide Posts Only" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("Hide Posts Only",'hmth'); ?>
                                </option>
                                
 								<option value="Hide Posts and Sidebar" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "Hide Posts and Sidebar" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("Hide Posts and Sidebar",'hmth'); ?>
                                </option>   
                                
                                </select>   
                            </td>						
                       	</tr>
					
					<?php
					break;


/* Nav and Footer Style
-------------------------------------------------------------- */

					case 'select-indexing': ?>
<?php if(  !(hmt4_get_option('hmt_seo_plugin') )    ) { ?>
						<tr>
							<td width="350"><?php echo $value['name']; ?>
							<small><a href="<?php echo $heatmap_link; ?>/version-<?php echo $baseversion; ?>/<?php echo $value['userguide']; ?>/" target="_blank"><strong class="questionmark">&nbsp;  </strong></a></small><br /><br />
							<?php echo $value['desc']; ?>
							
							</td>
							
                            <td width="350">
                                <select
                                
                                style="width:280px;"
                                name="<?php echo $value['id']; ?>"
                                id="<?php echo $value['id']; ?>">
                                
                                <option value="Home, Pages and Posts" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "Home, Pages and Posts" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("Home, Pages and Posts",'hmth'); ?>
                                </option>
                                
 								<option value="Home, Pages, Posts and Categories" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "Home, Pages, Posts and Categories" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("Home, Pages, Posts and Categories",'hmth'); ?>
                                </option>  
                                
                                <option value="Home, Pages, Posts and Tags" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "Home, Pages, Posts and Tags" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("Home, Pages, Posts and Tags",'hmth'); ?>
                                </option> 
                                
                                 <option value="Home, Pages, Posts and Archives" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "Home, Pages, Posts and Archives" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("Home, Pages, Posts and Archives",'hmth'); ?>
                                </option>  
                                
                                <option value="Index Everything" 
                                    <?php if ( hmt4_get_option( $value['id'] ) == "Index Everything" ) { echo ' selected="selected"'; } ?>>
                                    <?php _e("Index Everything",'hmth'); ?>
                                </option>
                                
                                </select>   
                            </td>						
                       	</tr>
				<?php } ?>	
					<?php
					break;	

															

				 
					}
				}
				?>
	
    
<?php			
/* Submit and Reset Buttons
-------------------------------------------------------------- */
?>
			 
				<p class="submit">
					<input name="save" type="submit" value="<?php _e('Save changes','hmth'); ?>" class="button-primary"/>
					<input type="hidden" name="action" value="save-options" />
				</p>
			</form>
			
			<form method="post" action="">
				<p class="submit">
				<input name="reset" type="submit" value="<?php _e('Reset HeatMap Theme Options','hmth'); ?>" class="button-secondary" />
				<input type="hidden" name="action" value="reset-options" />
			</p>
			</form>
			
			</div>
			
			<?php right_options_column(); ?>		
		
		</div>
</div>
		
<?php
}

			
/* This is the right column of the options page
-------------------------------------------------------------- */

function right_options_column (){
	
	global $themename, $shortname, $options, $baseversion, $thisversion, $subtitle, $heatmap_link;
?>
    <div style="float:left">
    
    <table class="widefat" cellspacing="0" style="width:350px; margin-left:15px;">
    
            <thead>
                <tr>
                    <th colspan="2" scope="col">
                        <?php _e('Latest News from','hmth'); ?><a href="<?php echo $heatmap_link; ?>"> HeatMapTheme.com</a>
                    </th>
                </tr>
            </thead>
        <tbody> 
                <tr>
                    <td width="350">
                        <?php
						hmt4_rss();
                        ?>	
                    </td>
                </tr>
        
        </tbody>
    </table>
    
    <br />


    
    <table class="widefat" cellspacing="0" style="width:350px; margin-left:15px;"> 
            <thead>
                <tr>
                    <th colspan="2" scope="col">
                        HeatMap Theme Pro <a href="<?php echo $heatmap_link; ?>/version-5/widget-positions" target="_blank">Widget Positions</a>
                    </th>
                </tr>
            </thead>
        <tbody>
                <tr>
                    <td width="350">
                    
                        <center><a href="<?php echo $heatmap_link; ?>/version-5/widget-positions" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/images/preset-images/widget-layout-small.gif" class="img_valign"  width="330" height="284"  alt="View Widget Positions User Guide"/></a></center> 
                    
                    </td>
                </tr>
        
        </tbody>
    </table>
    
    <br />
    
    <table class="widefat" cellspacing="0" style="width:350px; margin-left:15px;">
            <thead>
                <tr>
                    <th colspan="2" scope="col">
                        <?php _e('Base Theme Info','hmth'); ?>
                    </th>
                </tr>
            </thead>
        <tbody>
                <tr>
                    <td width="150">
                        <strong><?php _e('Theme Author:','hmth'); ?></strong><br />
                        <?php _e('Theme Name:','hmth'); ?><br />
                        <?php _e('Base Version:','hmth'); ?><br />
                        <?php _e('This Version:','hmth'); ?>
                    </td>
                    <td width="200">
                        <strong><a href="<?php echo 'http://stuartwider.com'; ?>">Stuart Wider</a></strong><br />
                        <?php echo $themename; ?><br />
                        <?php echo $baseversion; ?><br />
                        <?php echo $thisversion; ?>
                    </td>
                </tr>
        
        </tbody>
    </table>
    
    <br />

    <?php 
    $ct = current_theme_info(); 
    if ($ct->parent_theme != '') {    // if the current theme is a child theme then display extra details form the current theme array.
    ?>
    
    <table class="widefat" cellspacing="0" style="width:350px; margin-left:15px;">
            <thead>
                <tr>
                    <th colspan="2" scope="col">
                        <?php _e('Pro Skin Info','hmth'); ?>
                    </th>
                </tr>
            </thead>
        <tbody>
                <tr>
                    <td width="150">
                        <strong><?php _e('Theme Author:','hmth'); ?></strong><br />
                        <?php _e('Theme Name:','hmth'); ?><br />
                        <?php _e('Version:','hmth'); ?>
                    </td>
                    <td width="200">
                        <?php 
                        echo '<strong>' . $ct->author . '</strong><br />'; 
                        echo $ct->name .'<br />';
                        echo $ct->version; 
                        ?>
                    </td>
                </tr>
        
        </tbody>
    </table>
    <br />
    
    <?php 
    } 
    ?>
    
    <table class="widefat" cellspacing="0" style="width:350px; margin-left:15px;">
            <thead>
                <tr>
                    <th colspan="2" scope="col">
                        <?php _e('Additional Contributors','hmth'); ?>
                    </th>
                </tr>
            </thead>
        <tbody>
                <tr>
                    <td width="350">
						<?php get_template_part("credits"); ?>
                    </td>
                </tr>
        
        </tbody>
    
        
    </table>
    
    <br />
    
    <table class="widefat" cellspacing="0" style="width:350px; margin-left:15px;">
            <thead>
                <tr>
                    <th colspan="2" scope="col">
                        &copy; <?php _e('Copyright, Licensing and Trademarks','hmth'); ?>
                    </th>
                </tr>
            </thead>
        <tbody>
                <tr>
                    <td width="350">
                        <p><a href="<?php echo $heatmap_link; ?>">HeatMap Theme</a> <?php _e('is copyright','hmth'); ?> <a href="<?php echo 'http://stuartwider.com'; ?>">Stuart Wider</a> <?php _e('2011 and distributed under the GPL3 License.','hmth'); ?></p>
                        <?php if ($ct->parent_theme != '') { ?><p><?php _e('All other HeatMap Theme related content may not be distributed without explicit permission from the Author.','hmth'); ?></p><?php } ?>
                        <p><a href="http://heatmaptheme.com/licensing" target="_blank"><?php _e('See Full Licensing Details','hmth'); ?></a></p>
                        <p><?php _e('Google Adsense, Analytics, FeedBurner and Custom Search are trademarks of Google Inc.','hmth'); ?></p>
                    </td>
                </tr>
        
        </tbody>
    
        
    </table>
    
</div>
<?php
}

/* It all starts here!
-------------------------------------------------------------- */

get_template_part("init-admin-options");
get_template_part("init-register-widgets");

if (!defined('HEADER_TEXTCOLOR')) define('HEADER_TEXTCOLOR', 'ffffff'); 
if (!defined('HEADER_IMAGE')) define('HEADER_IMAGE', get_stylesheet_directory_uri() . '/images/header-bg.png');
if (!defined('HEADER_IMAGE_WIDTH')) define('HEADER_IMAGE_WIDTH', 980); 
if (!defined('HEADER_IMAGE_HEIGHT')) define('HEADER_IMAGE_HEIGHT', 110);

if ( ! isset( $content_width ) ) $content_width = 645;

add_custom_image_header('header_style', 'admin_header_style');
add_custom_background();

hmt_set_up_vars();
hmt_register_widgets();
hmt4_initialise_option();

if (function_exists('hmt_child_theme')) hmt_child_theme();	// If there a child theme is active then initialise any special functions within it.

add_action('admin_menu', 'hmt_add_admin');
add_action( 'init', 'hmt_register_menus' );
add_action( 'wp_dashboard_setup', 'hmt_dashboard_setup_function' );

add_action('admin_menu', 'hmt_add_admin');
add_action( 'init', 'hmt_register_menus' );

add_editor_style();

if (function_exists('add_theme_support')) {						
	add_theme_support( 'post-thumbnails' );	 					// this adds in the 'new for 2.9' Auto Thumbnail feature
	set_post_thumbnail_size( 75, 75, true);  					// sets the pixel width and height for the recent posts plus widget
	add_image_size( 'post-image-size', 290, 9999);				// sets the pixel width for posts and pages of the Auto Thumbnail - in this case 290 wide by any width high.
	add_image_size( 'archive-image-size', 150, 150);
	add_theme_support('automatic-feed-links');
}	

get_template_part("shortcodes" );
get_template_part("post_temp_plg" );
get_template_part("custom_field_plg" );


get_template_part("allow_html_plg" );


if( !  wp_count_posts()->publish ) { 
remove_action( 'wp_head', 'feed_links_extra', 3 );
 	remove_action( 'wp_head', 'feed_links', 2 );
}


$this_excerpt_length = hmt4_get_option('hmt_auto_excerpt_length');

if ($this_excerpt_length) {
   add_filter('excerpt_length', 'new_excerpt_length');			// If the excerpt length settings is set then tell wordpress to create the excerpt automatically.
}

add_filter('the_content_more_link', 'remove_more_jump_link');

// Thanks to Nathan Rice for Single Post Template Code - http://www.nathanrice.net
add_filter('single_template', create_function('$t', 'foreach( (array) get_the_category() as $cat ) { if ( file_exists(TEMPLATEPATH . "/single-{$cat->term_id}.php") ) return TEMPLATEPATH . "/single-{$cat->term_id}.php"; } return $t;' ));
?>