<?php
/* 
This file is part of HeatMap Theme Pro v5
Website: HeatMapTheme.com
*/

//	Adds a custom section to the Post edit screen
add_action('admin_menu', 'hmt_add_custom_field_box');
function hmt_add_custom_field_box() {
	if( function_exists( 'add_meta_box' )) {


		add_meta_box( 'hmt_custom_field_seo', __( 'HeatMap Theme Pro - SEO', 'hmth' ), 'hmt_inner_custom_seo_box', 'post', 'normal', 'high' ); //add the boxes under the post
		add_meta_box( 'hmt_custom_field_seo', __( 'HeatMap Theme Pro - SEO', 'hmth' ), 'hmt_inner_custom_seo_box', 'page', 'normal', 'high' ); //add the boxes under the page

		add_meta_box( 'hmt_custom_field_recentpost', __( 'HeatMap Theme Pro - Recent Posts Plus Widget', 'hmth' ), 'hmt_inner_custom_recentpost_box', 'post', 'normal', 'high' ); //add the boxes under the post

		add_meta_box( 'hmt_custom_field_afflink', __( 'HeatMap Theme Pro - Affiliate Links', 'hmth' ), 'hmt_inner_custom_afflink_box', 'post', 'normal', 'high' ); //add the boxes under the post


	}
}



//	Prints the inner fields for the custom post/page section
function hmt_inner_custom_seo_box() {
	global $post;
	// Use nonce for verification
	echo '<input type="hidden" name="hmt_noncename_seo" id="hmt_noncename_seo" value="' . wp_create_nonce( plugin_basename(__FILE__) ) . '" />';
	// The actual fields for data entry


global  $baseversion;
	echo '<table width="100%"  cellspacing="0" border="0">';
	if (!hmt4_get_option('hmt_seo_plugin'))
	{
		echo '<tr><th  align="left" valign="top" width="20%">'. __('Meta Description','hmth') .'<small><a href="http://heatmaptheme.com/version-'.$baseversion.'/post-page-meta-description/"><strong class="questionmark">  </strong></a></small> </th><td  > <textarea style="width:340px; height:90px; font-size:11px;" name="hmt-meta-description" id="hmt-meta-description" >' . get_post_meta($post->ID, "meta-description", TRUE)  . '</textarea><br><br></td></tr>';
		echo '<tr><th  align="left"  valign="top" style="padding-top: 6px;">'. __('Meta Keywords','hmth') .'<small><a href="http://heatmaptheme.com/version-'.$baseversion.'/post-page-meta-keywords/"><strong class="questionmark">  </strong></a></small></th><td style="padding-top: 6px;"><textarea name="hmt-meta-keywords" style="width:340px; height:90px; font-size:11px;" id="hmt-meta-keywords"  >' . get_post_meta($post->ID, "meta-keywords", TRUE) . '</textarea><br><br></td></tr>';
	}
	echo '<tr><th  align="left"  valign="top" style="padding-top: 6px;">'. __('SEO Text','hmth') .'<small><a href="http://heatmaptheme.com/version-'.$baseversion.'/post-page-seo-text/"><strong class="questionmark">  </strong></a></small></th><td style="padding-top: 6px;"><textarea name="hmt-seo-text" style="width:340px; height:90px; font-size:11px;" id="hmt-seo-text"  >' . get_post_meta($post->ID, "seo-text", TRUE) . '</textarea><br><br></td></tr>';

	echo '<tr><th  align="left"  valign="top" style="padding-top: 6px;">'. __('More Text','hmth') .'<small><a href="http://heatmaptheme.com/version-'.$baseversion.'/post-page-more-text/"><strong class="questionmark">  </strong></a></small></th><td style="padding-top: 6px;"><input type="text" name="hmt-more-text" style="width:340px;  font-size:11px;" id="hmt-more-text" value="' . get_post_meta($post->ID, "more-text", TRUE) . '" /><br><br></td></tr>';

echo '</table>';
	

}

function hmt_inner_custom_recentpost_box() {
	global $post;
global  $baseversion;
echo hmt_questionmark_style ();
	// Use nonce for verification
	echo '<input type="hidden" name="hmt_noncename_recent" id="hmt_noncename_recent" value="' . wp_create_nonce( plugin_basename(__FILE__) ) . '" />';
	// The actual fields for data entry

	echo '<table   width="100%"  cellspacing="0" border="0">';

	echo '<tr><th  width="20%" align="left"  valign="top" style="padding-top: 6px;">'. __('Short Excerpt','hmth') .'<small><a href="http://heatmaptheme.com/version-'.$baseversion.'/recent-post-short-excerpt/"><strong class="questionmark">  </strong></a></small></th><td style="padding-top: 6px;"><textarea name="hmt-short-excerpt" style="width:340px; height:90px; font-size:11px;" id="hmt-short-excerpt"  >' . get_post_meta($post->ID, "short-excerpt", TRUE) . '</textarea><br><br></td></tr>';

	echo '<tr><th  align="left"  valign="top" style="padding-top: 6px;">'. __('Short More Text','hmth') .'<small><a href="http://heatmaptheme.com/version-'.$baseversion.'/recent-post-short-more/"><strong class="questionmark">  </strong></a></small></th><td style="padding-top: 6px;"><input type="text" name="hmt-short-more-text" style="width:340px; font-size:11px;" id="hmt-short-more-text"  value="' . get_post_meta($post->ID, "short-more-text", TRUE) . '" /><br><br></td></tr>';


echo '</table>';
	
}


function hmt_inner_custom_afflink_box() {
	global $post;
global  $baseversion;
	// Use nonce for verification
	echo '<input type="hidden" name="hmt_noncename_afflink" id="hmt_noncename_afflink" value="' . wp_create_nonce( plugin_basename(__FILE__) ) . '" />';
	// The actual fields for data entry

	echo '<table   width="100%"  cellspacing="0" border="0">';

	echo '<tr><th  align="left"  valign="top" style="padding-top: 6px;">'. __('Affiliate Link Text','hmth') .'<small><a href="http://heatmaptheme.com/version-'.$baseversion.'/aff-link-text/"><strong class="questionmark">  </strong></a></small></th><td style="padding-top: 6px;"><input type="text" name="hmt-aff-link-text" style="width:340px; font-size:11px;" id="hmt-aff-link-text"  value="' . get_post_meta($post->ID, "aff-link-text", TRUE) . '" /><br><br></td></tr>';

	echo '<tr><th  width="20%" align="left"  valign="top" style="padding-top: 6px;">'. __('Affiliate Link','hmth') .'<small><a href="http://heatmaptheme.com/version-'.$baseversion.'/aff-link/"><strong class="questionmark">  </strong></a></small></th><td style="padding-top: 6px;"><input name="hmt-aff-link" style="width:340px;  font-size:11px;" id="hmt-short-excerpt" type="text"  value="' . get_post_meta($post->ID, "aff-link", TRUE) . '" /><br><br></td></tr>';

	echo '<tr><th  width="20%" align="left"  valign="top" style="padding-top: 6px;">'. __('Affiliate Link nofollow','hmth') .'<small><a href="http://heatmaptheme.com/version-'.$baseversion.'/aff-link-nofollow/"><strong class="questionmark">  </strong></a></small></th><td style="padding-top: 6px;"><input name="hmt-aff-link-nofollow"  id="hmt-aff-link-nofollow" type="checkbox"  '; 
if( get_post_meta($post->ID, "aff-link-nofollow", TRUE) )
{
echo ' checked="checked" ';
} 
echo '" /><br><br></td></tr>';

	echo '<tr><th  align="left"  valign="top" style="padding-top: 6px;">'. __('Featured Image Link','hmth') .'<small><a href="http://heatmaptheme.com/version-'.$baseversion.'/featured-img-link/"><strong class="questionmark">  </strong></a></small></th><td style="padding-top: 6px;"><input type="text" name="hmt-featured-img-link" style="width:340px; font-size:11px;" id="hmt-featured-img-link"  value="' . get_post_meta($post->ID, "featured-img-link", TRUE) . '" /><br><br></td></tr>';


	echo '<tr><th  width="20%" align="left"  valign="top" style="padding-top: 6px;">'. __('Featured Image Link nofollow','hmth') .'<small><a href="http://heatmaptheme.com/version-'.$baseversion.'/featured-img-link-nofollow/"><strong class="questionmark">  </strong></a></small></th><td style="padding-top: 6px;"><input name="hmt-featured-img-link-nofollow"  id="hmt-featured-img-link-nofollow" type="checkbox"  '; 
if( get_post_meta($post->ID, "aff-link-nofollow", TRUE) )
{
echo ' checked="checked" ';
} 
echo '" /><br><br></td></tr>';

echo '</table>';
	
}



//	When the post is saved, saves our custom data
add_action('save_post', 'hmt_save_postdata', 1, 2); // save the custom fields
function hmt_save_postdata($post_id, $post) {
	


	// Is the user allowed to edit the post or page?
	if ( isset($_POST['post_type']) && 'page' == $_POST['post_type'] ) {
		if ( !current_user_can( 'edit_page', $post->ID ))
		return $post->ID;
	} else {
		if ( !current_user_can( 'edit_post', $post->ID ))
		return $post->ID;
	}
	
	$mydata=array();

	// OK, we're authenticated: we need to find and save the data
	
	// We'll put the data into an array to make it easier to loop though and save
if ( isset($_POST['hmt_noncename_seo']) && wp_verify_nonce( $_POST['hmt_noncename_seo'], plugin_basename(__FILE__) )) {
	if(isset($_POST['hmt-meta-description']))
	{
		$mydata['meta-description'] = $_POST['hmt-meta-description'];
	}
	if(isset($_POST['hmt-meta-keywords']))
	{
		$mydata['meta-keywords'] = $_POST['hmt-meta-keywords'];
	}
	$mydata['seo-text'] = $_POST['hmt-seo-text'];
	$mydata['more-text'] = $_POST['hmt-more-text'];
}

if( isset($_POST['hmt_noncename_recent']) && wp_verify_nonce( $_POST['hmt_noncename_recent'], plugin_basename(__FILE__) ) )
{
	$mydata['short-excerpt'] = $_POST['hmt-short-excerpt'];
	$mydata['short-more-text'] = $_POST['hmt-short-more-text'];
}

if( isset($_POST['hmt_noncename_afflink']) && wp_verify_nonce( $_POST['hmt_noncename_afflink'], plugin_basename(__FILE__) ) )
{
	$mydata['aff-link'] = "";
	$mydata['aff-link-nofollow'] = "";
	$mydata['aff-link-text'] = "";
	$mydata['featured-img-link'] = "";
	$mydata['featured-img-link-nofollow'] ="";

	if(isset($_POST['hmt-aff-link']))
	{
		$mydata['aff-link'] = $_POST['hmt-aff-link'];
	}
	if(isset($_POST['hmt-aff-link-nofollow']))
	{
		$mydata['aff-link-nofollow'] = $_POST['hmt-aff-link-nofollow'];
	}
	if(isset($_POST['hmt-aff-link-text']))
	{
		$mydata['aff-link-text'] = $_POST['hmt-aff-link-text'];
	}
	if(isset($_POST['hmt-featured-img-link']))
	{
		$mydata['featured-img-link'] = $_POST['hmt-featured-img-link'];
	}
	if(isset($_POST['hmt-featured-img-link-nofollow']))
	{
		$mydata['featured-img-link-nofollow'] = $_POST['hmt-featured-img-link-nofollow'];
	}
}


	// Add values of $mydata as custom fields
	foreach ($mydata as $key => $value) { //Let's cycle through the $mydata array!
		if( $post->post_type == 'revision' ) return; //don't store custom data twice
		$value = implode(',', (array)$value); //if $value is an array, make it a CSV (unlikely)
		if(get_post_meta($post->ID, $key, FALSE)) { //if the custom field already has a value...
			update_post_meta($post->ID, $key, $value); //...then just update the data
		} else { //if the custom field doesn't have a value...
			add_post_meta($post->ID, $key, $value);//...then add the data
		}
		if(!$value) delete_post_meta($post->ID, $key); //and delete if blank
	}
}

?>