<?php

	function wpblmachine_print_remaining_backlinks() {
	?>
	<span style="float:right"><table class="widefat"><tr><th scope="row" style="padding:15px;padding-bottom:1px;font-size:1.2em"><b>Remaining Backlinks:</b></th><td style="padding:15px;padding-bottom:1px;font-size:1.2em"><?php echo wpblmachine_get_remaining_links(); ?></td></tr><tr><td colspan="2" style="text-align:center"><a href="https://backlinkmachine.com/app/" target="_blank">Members area</a></td></tr></table></span><div style="clear:both"></div>
	<?php
	}

	function wpblmachine_print_posts_list( $post_type = 'post', $search_term = '', $page = 0, $per_page = 50 ) {
		global $wpdb;
		$args = array(
			'post_type' => $post_type,
			'posts_per_page'   => $per_page,
			'offset'           => ( ( $page -1 ) * $per_page ),
		);
		if( !empty( $search_term ) )
			$args['s'] = $search_term;

		$posts = get_posts( $args );

		$total_query = "SELECT COUNT(id) FROM {$wpdb->prefix}posts WHERE post_type = '$post_type' AND post_status = 'publish' ";
		if( !empty( $search_term ) )
			$total_query .= " AND (post_title LIKE '%".$search_term."%' OR post_content LIKE '%".$search_term."%' )";
		$total = $wpdb->get_var( $total_query );
		$num_of_pages = ceil( $total / $per_page );


		$str_ret = '<table class="widefat">';
		$str_ret .= '<thead><tr><th scope="col">Id</th><th scope="col">Name</th><th scope="col">&nbsp;</th></tr></thead><tbody>';
		if( $posts ) {
			foreach( $posts as $post ) {
				$str_ret .= '<tr><td class="post_id">'.$post->ID.'</td><td class="post_name">'.get_the_title( $post->ID ).'</td><td><input type="button" value="Get Backlinks" class="button button-primary button-get-backlinks"> <a class="button button-secondary post_url" href="'.get_permalink( $post->ID ).'" target="_blank">Preview</a></td></tr>';
			}
		}
		$str_ret .= '</tbody></table>';
		echo $str_ret;

		$page_links = paginate_links( array(
			'base' => add_query_arg( /*'pagenum', '%#%'*/ array(
				    'pagenum' => '%#%',
				    'posttype' => $post_type,
				)
			),
			'format' => '',
			'end_size' => 4,
			'mid_size' => 3,
			'prev_text' => __( '«', 'text-domain' ),
			'next_text' => __( '»', 'text-domain' ),
			'total' => $num_of_pages,
			'current' => $page
		) );
		if ( $page_links ) {
		echo '<div class="tablenav"><div class="tablenav-pages" style="margin: 1em 0;">' . $page_links . '</div></div>';
		}
	}

	function wpblmachine_popup() {
	?>
	<div id="wpblmodal" style="display:none">
		<h3 style="text-align:center">Backlink Machine</h3>
		<table class="form-table" id="get-backlinks-table">
			<tr valign="top">
				<th scope="row" style="width:100px">Post</th>
				<td>
					<span id="wpbl-post-name">&nbsp;</span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row" style="width:100px">Keywords</th>
				<td>
					<textarea class="widefat" id="wpbl-keywords" rows="4" placeholder="Keywords (one keyword per line)"></textarea>
					<br/>
					<button class="button button-secondary" id="blm-import-from-tags">Import from Post Tags</button> &nbsp <span id="bl-notags" style="display:none;padding-top:5px;"">No tags found</span>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row" style="width:100px">Number of Backlinks</th>
				<td>
					<?php wpblmachine_backlinks_num_select(); ?>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row" style="width:100px">&nbsp;</th>
				<td>
					<button type="button" id="do-get-backlinks" class="button button-primary">Get backlinks!</button>
				</td>
			</tr>
		</table>
		<div id="wpblmachine-results" style="display:none">

		</div>
	</div>
	<?php
	}

	function wpblmachine_backlinks_num_select( $value = 0, $reduced = false ) {
		if( $reduced )
			$num = array( 1, 2, 3, 5, 10, 20, 30, 40, 50 );
		else
			$num = array( 1, 2, 3, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100 );

		$str_ret = '<select name="wpbl-backlinks-num" id="wpbl-backlinks-num">';
		foreach( $num as $n )
			$str_ret .= '<option value="'.$n.'" '.selected( $n, $value, false) .'>'.$n.'</option>';
		$str_ret .= '</select>';
		echo $str_ret;
	}

	function wpblmachine_print_log( $page = 0, $per_page = 50 ) {
		$args = array();
		$log = wpblmachine_get_log( $page, $per_page );
		$str_ret = '<table class="widefat">';
		$str_ret .= '<thead><tr><th scope="col">#</th><th scope="col">Post</th><th scope="col">Keywords</th><th scope="col">Num links</th><th scope="col">Date</th><th scope="col">Type</th><th scope="col">&nbsp;</th></tr></thead><tbody>';
		if( $log ) {
			$i = ( $page * $per_page ) + 1;
			foreach( $log as $entry ) {
				$str_ret .= '<tr><td>'.$i++.'</td><td><a href="'.get_permalink( $entry->post_id ).'" target="_blank">'.get_the_title( $entry->post_id ).'</a></td><td>'.wpblmachine_keywords_to_txt( $entry->keywords ).'</td><td>'.$entry->num_links.'</td><td>'.$entry->created_at_f.'</td><td>'.wpblmachine_type_to_str( $entry->bl_type ).'</td><td> <a class="button button-secondary" href="'.wpblmachine_report_url( $entry->job_id ).'" target="_blank">View Report</a></td></tr>';
			}
		}
		$str_ret .= '</tbody></table>';
		echo $str_ret;
	}

	function wpblmachine_type_to_str( $type ) {
		return( $type ? 'Auto' : 'Manual' );
	}
	function wpblmachine_report_url( $job_id ) {
		$settings = wpblmachine_get_plugin_settings();
		return WPBLMACHINE_REPORTS_URL.'?api='.$settings['apikey'].'&jobid='.$job_id;
	}

	function wpblmachine_keywords_to_txt( $keywords_txt ) {
		if( empty( $keywords_txt ) )
			return '';
		$keywords_array = json_decode( $keywords_txt );
		if( empty( $keywords_array ) )
			return '';
		return stripslashes( implode( ', ', $keywords_array ) );
		$str_ret = '';
		foreach( $keywords_array as $keyword ) {
			$str_ret .= stripslashes( $keyword ).', ';
		}
		return $str_ret;
	}
?>