<?php
if ( !class_exists( 'ASDashboard' ) ) {
	class ASDashboard {
		var $plugin_name;
		var $feed = 'http://wpsocialcontact.com/products/custom-feed/';
		var $num_items = 5;
		var $quick = 0;
		function __construct( $plugin_name ) {
			$this->plugin_name = $plugin_name;
			add_action('wp_dashboard_setup', array( $this, 'add_dashboard_widget' ) );
			add_action('wp_user_dashboard_setup', array( $this, 'add_dashboard_widget' ) );
			add_action('wp_newtwork_dashboard_setup', array( $this, 'add_dashboard_widget' ) );
		}

		function add_dashboard_widget() {
			add_meta_box( 'asdashboard-widget', 'Recommended Internet Marketing Tools', array( $this, 'show_dashboard_widget' ), 'dashboard', 'side', 'high');
		}

		function show_dashboard_widget() {
			$str = '';
			if( $this->quick )
				add_filter( 'wp_feed_cache_transient_lifetime' , array( $this, 'update_feed_quickly' ) );
			$rss = fetch_feed( $this->feed );
			if( $this->quick )
				remove_filter( 'wp_feed_cache_transient_lifetime', array( $this, 'update_feed_quickly' ) );

		    if ( is_wp_error($rss) ) {
				if ( is_admin() || current_user_can('manage_options') ) {
				   echo '<p>';
				   printf(__('<strong>RSS Error</strong>: %s'), $rss->get_error_message());
				   echo '</p>';
				}
		    	return;
			}

			if ( !$rss->get_item_quantity() ) {
			     echo '<p>Apparently, there are no updates to show!</p>';
			     $rss->__destruct();
			     unset($rss);
			     return;
			}

			$str .= '<ul>';

			if ( !isset($items) )
			     foreach ( $rss->get_items(0, $this->num_items) as $item ) {
			          $publisher = '';
			          $site_link = '';
			          $link = '';
			          $content = '';
			          $date = '';
			          $link = esc_url( strip_tags( $item->get_link() ) );
			          $link = add_query_arg( 'tid', 'dash_'.$this->plugin_name, $link );
			          $title = esc_html( $item->get_title() );
			           $cat = $item->get_item_tags('', 'thumbnail');
			           $thumbnail_img = $cat[0]['data'];
			          $content = $item->get_content();
			          $content = wp_html_excerpt($content, 300, '[...]');
			          $content .= "<p style='text-align:right'><a href='$link'  target='_blank'>Learn More</a></p>";

			         $str .= "<li>
			         	<div style='float:left;width:18%;margin-right:4%;display:block;padding-top:4px'><a href='$link' target='_blank'><img src='".$thumbnail_img."' style='width:100%;height:auto' /></a></div>
			         	<div style='float:left;width:78%'><a class='rsswidget' href='$link' target='_blank'>$title</a>\n<div class='rssSummary'>$content</div></div>
			         	<div class='clear'></div>
			         	</li>\n<li><hr/></li>";
			}

			$str .= '</ul><div style="clear:both"></div><a href="http://customerhelpdesk.in" class="button button-secondary" target="_blank">Support</a><!-- <a href="http://licensemachine.com" class="button button-primary" target="_blank">View All</a>--><a style="float:right" href="#" id="wp_asdashboard_hide">Don\'t show this widget</a><div style="clear:both"></div>';

			$str .= '<script type="text/javascript">
				jQuery( document ).ready(function() {
					jQuery("#wp_asdashboard_hide").click(function( e ){
						e.preventDefault();
						jQuery("#asdashboard-widget-hide").trigger("click");
					});
				});
			</script>';
			echo $str;
			$rss->__destruct();
			unset($rss);
		}

		function update_feed_quickly( $seconds ) {
		  return 5;
		}
	}
	$as_dashboard = new ASDashboard( 'blmachine' );
}

?>