<xsl:stylesheet version="2.0"
		xmlns:html="http://www.w3.org/TR/REC-html40"
		xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
		xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
		<head>
			<title>XML Sitemap</title>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
			<style type="text/css">
				
	body {
		font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
		color: #444;
	}
	
	#intro {
		background-color:#CFEBF7;
		border:1px #2580B2 solid;
		padding:5px 13px 5px 13px;
		margin:10px;
	}
	
	#intro p {
		line-height:	16.8667px;
	}
	#intro strong {
		font-weight:normal;
	}

	#sitemap__table {
		border: solid 1px #ccc;
		border-collapse: collapse;
	}

	#sitemap__table tr th {
		text-align: left;
	}

	#sitemap__table tr td,
	#sitemap__table tr th {
		padding: 10px;
	}

	#sitemap__table tr:nth-child(odd) td {
		background-color: #eee;
	}

	a:hover {
		text-decoration: none;
	}
			</style>
		</head>
		<body>
			<div id="intro">
				<p>
					This is an XML Sitemap which is supposed to be processed by search engines that follow the XML Sitemap standards like Google, Bing and other Search Engines.<br />
					It is generated using the WordPress sitemap and the <a href="https://wordpress.org/plugins/platinum-seo-pack/">SEO Plugin for WordPress</a>, <strong>Platinum SEO Plugin</strong> by <strong>Techblissonline.com</strong>
				</p>
			</div>
			<div id="sitemap__header">
				<h1>XML Sitemap</h1>
				<p>This XML Sitemap is generated by WordPress to make your content discoverable by search engines. Learn more about XML sitemaps on <a href="https://www.sitemaps.org/">sitemaps.org</a>.</p>
			</div>
			<div id="sitemap__content">
				<p class="text">This XML Sitemap contains <xsl:value-of select="count(sitemap:sitemapindex/sitemap:sitemap)"/> URLs.</p>
				<table id="sitemap__table">
					<thead>
					<tr>
						<th>URL</th>					    
					</tr>
					</thead>
					<tbody>
					<xsl:for-each select="sitemap:sitemapindex/sitemap:sitemap">
						<tr>
							<td>
								<xsl:variable name="itemURL">
									<xsl:value-of select="sitemap:loc"/>
								</xsl:variable>
								<a href="{$itemURL}">
									<xsl:value-of select="sitemap:loc"/>
								</a>
							</td>							
						</tr>
					</xsl:for-each>
					</tbody>
				</table>

			</div>
		</body>
		</html>
	</xsl:template>
	</xsl:stylesheet>