<?php 
/* 
This file is part of HeatMap Theme Pro v5
Copyright: Stuart Wider
Website: HeatMapTheme.com
*/
?>

<?php get_header(); ?>


<!--
single.php
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>> 
		
<!--
Content of the page (inc comments and post details)
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->
	
    <div id="page-body-wrapper">
            
        <div id="content">
                
        <?php global $have_posts; ?>        
                    
        <?php
        if ($have_posts):
        ?>
        
        <?php $ids[0] = get_the_ID(); /* grabs the id of the page so it can be excluded in the recent posts plus widget */ ?>  
	
<!--
The Post
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->
	
			<div class="post-content">
	
<!--
Widget Area: [All Content] Above 
~~~ -->
				<?php 
                if (hmt_is_sidebar_active('sidebar-7')):
                ?>
                    
                    <div id="all-content-above">
                    
                        <span class="all-content-above-widget-block">
                            <?php dynamic_sidebar('sidebar-7'); ?>
                        </span>
                    
                    </div> <!-- id="all-content-above" -->
                
                <?php
                endif;
                ?>
	
<!--
The Post Title 
~~~ -->			
	
				<?php
                if (!hmt4_get_option('hmt_hide_post_titles')) {
                    
                    if (!hmt4_get_option('hmt_assign_h2_post_titles')){ ?>
                        <h1 class="h1-underline"><?php the_title(); ?></h1>  
                    <?php 
                    } else {
                    ?>
                        <h2 class="h2-simulate-h1-size-underline"><?php the_title(); ?></h2>
                    <?php
                    }
                }
                ?>
                 
<!--
Widget Area: [Content Item] Above 
~~~ -->			
				<?php
                if (hmt_is_sidebar_active('sidebar-9')):
                ?>
                    
                    <div id="content-item-above">
                    
                        <span class="content-item-above-widget-block">
                            <?php dynamic_sidebar('sidebar-9'); ?>
                        </span>
                    
                    </div> <!-- id="content-item-above" -->
                
                <?php
                endif;
                ?>
<!--
Widget Area: [Content Item] Left 
~~~ -->	
				<?php 
                if (hmt_is_sidebar_active('sidebar-11')):
                ?>
                    <div id="content-item-left">
                        
                        <ul>
                        <?php dynamic_sidebar('sidebar-11'); ?>
                        </ul>
                    
                    </div> <!-- id="content-item-left" -->
                <?php
                endif;
                ?>
<!--
Widget Area: [Content Item] Right 
~~~ -->
				<?php 
                if (hmt_is_sidebar_active('sidebar-12')):
                ?>
                    <div id="content-item-right">
                        
                        <ul>
                        <?php dynamic_sidebar('sidebar-12'); ?>
                        </ul>
                    
                    </div> <!-- id="content-item-right" -->
                <?php
                endif;
                ?>	
<!--
The content itself 
~~~ -->
				<?php
                if (function_exists('has_post_thumbnail') && has_post_thumbnail()) { //  okay so if this post has a thumbnail (as per wp 2.9 thumnail features) then do something about it
                
                    if (hmt4_get_option('hmt_post_thumbnail_left_or_right')!='OFF') {
                        if (hmt4_get_option('hmt_post_thumbnail_left_or_right')=='RIGHT') print '<div class="post-thumbnail-right">';
                        else print '<div class="post-thumbnail-left">';	

                        
                        if( get_post_meta($post->ID, "aff-link", true)){  
                        	echo ' <a href="'.get_post_meta($post->ID, "aff-link", true).'" ';                         
                        	if( get_post_meta($post->ID, "aff-link-nofollow", true)){  echo ' rel="nofollow" '; } 
                       		echo '  title="' . the_title_attribute('echo=0') . '" target="_blank" >';
                        }
	   
                        the_post_thumbnail('post-image-size');
			if( get_post_meta($post->ID, "aff-link", true)){
                        	echo "</a>";
                        }

                        ?>
                        </div>
                <?php 	
                    }
                }
    
                the_content('');
                edit_post_link(__('(Edit)','hmth'), '<p>', '</p>'); ?>
			
<!--
Pagination for Multi-page posts
~~~ -->
				<?php wp_link_pages('before=<p class="multi-page">' . __('Pages:','hmth') . '&after=</p>');  /* if this is a multipage post then show the navigation */ ?>
<!--
Widget Area: [Content Item] Below
~~~ -->
				<?php
                if (hmt_is_sidebar_active('sidebar-10')):
                ?>
                    <div id="content-item-below">
                        <span class="content-item-below-widget-block">
                            <?php dynamic_sidebar('sidebar-10'); ?>
                        </span>
                    </div> <!-- id="content-item-below" -->
                        
                    <div class="clearFloat"></div>
                <?php 
                endif;
                ?>
          
            </div> <!-- class="post-content" -->
        
            <div class="clearFloat"></div>
	
<!--
Post Details 
~~~ -->
<?php            

               $leave_out_details ="";
               $leave_out_comments="";
?>

            <?php if (hmt4_get_option('hmt_hide_details_for_posts')) $leave_out_details = true; ?>
            <?php if (hmt4_get_option('hmt_hide_comments_for_posts')) $leave_out_comments = true; ?>
    
            <?php 
            
            /* logic to enable hiding of post details as per settings in the heatmap options admin */
            
            if (!$leave_out_details) { /* the logic here is reverse to what you think */ 
            ?> 
    
                <div class="post-details">
                
                	<?php get_template_part('like-buttons'); ?>
    
                    <p class="comment-button-box">
                    <?php 
                    if (($post->comment_status != 'closed')) { // if comments are not closed then show the comments button ?>
                        
                        <?php 
                        if (!$leave_out_comments) { ?>
                            <span class="comment-button"><a href="<?php the_permalink(); ?>#respond"><?php comments_number(__('Be the first to comment','hmth'), __('1 comment','hmth'), __('% comments','hmth'));?></a><?php if ('closed' != $post->comment_status){ print ' - '; _e('What do you think?','hmth'); }?></span><br /> 
                        <?php 
                        }
                    } else {
                    ?>	
                        <?php
                        $number_of_comments = get_comments_number();
                        if ($number_of_comments > 0) {
                        ?>
                            <?php 
                            if (!$leave_out_comments) { 
                            ?>
                                <span class="comment-button"><?php comments_number(__('No comments','hmth'), __('1 Comment','hmth'), __('% Comments','hmth'));?></span>&nbsp;<?php _e('[Comments are now closed for this post]','hmth') ?><br/>
                            <?php 
                            }
                        }
                    } 
                    ?>
                    
                    <?php if (!$leave_out_details) { ?><?php _e('Posted by','hmth'); ?>
                        <?php echo get_the_author(); ?>
                        <?php /* the_author_posts_link(); */ /*uncomment this if you actually want a link to the authors posts - it reveals the authors username though - or am I being too security concious? */?>
                         - 
                        <?php echo get_the_date();?> <?php _e('at','hmth'); ?>  <?php the_time(); /* changed date and time format so that default system date and time is used instead of preset date and time */ ?>
                    <?php }?>
                    </p>
                    
                    <?php 
                    if (is_single()) { 
                    ?>
                        <p><?php _e('Categories','hmth'); ?>:
                            <?php the_category(', ') ?>
                        &nbsp;<?php _e('Tags','hmth'); ?>:
                            <?php the_tags('') ?>
                        </p>
                    <?php
                    }
                    ?>
            
                </div> <!-- class="post-details" -->
            
            <?php 
            } 
            else if (!$leave_out_comments) { /* logic so to allow only the comments # button to show as set in the Heatmap Admin  */ ?>
                    
                <?php 
                if (($post->comment_status != 'closed')) { // if comments are not closed then show the comments button ?>
                
                    <div class="post-details nobg">
                    
                    	<?php get_template_part('like-buttons'); ?>
                
                        <p class="comment-button-box"><span class="comment-button"><a href="<?php the_permalink(); ?>#respond"><?php comments_number(__('Be the first to comment','hmth'), __('1 comment','hmth'), __('% comments','hmth'));?></a><?php if ('closed' != $post->comment_status){ print ' - '; _e('What do you think?','hmth'); }?></span></p>
            
                    </div> <!-- class="post-details" -->
        
                <?php 
                } else { 
                ?>
                
                    <?php
                    $number_of_comments = get_comments_number();
                    if ($number_of_comments > 0) {
                    ?>
    
                    <div class="post-details nobg">
                                
                        <p class="comment-button-box"><span class="comment-button"><?php comments_number(__('No comments','hmth'), __('1 Comment','hmth'), __('% Comments','hmth'));?></span>&nbsp;<?php _e('[Comments are now closed for this post]','hmth'); ?></p>
                    
                    </div> <!-- class="post-details" -->
                    
                    <?php
                    }
                } 
            }
            ?> 
        
            <!--
            <?php trackback_rdf(); ?>
            -->
        
            <?php else: ?>
                <h2 class="h2-simulate-h1-size"><?php _e('No posts found','hmth') ?></h2>
            <?php endif; ?>
	

<!--
The comments
~~~ -->
			<?php 
            if ((!$leave_out_comments)||!$leave_out_details) { /* the logic here is reverse to what you think */ 
            ?>
        
                <div class="comment-item">
                    <?php comments_template('',true); ?>
                </div> <!-- class="comment-item" -->
            
            <?php 
            } 
            ?> 
	
<!--
Widget Area: [All Content] Below
~~~ -->
			<?php
            if (hmt_is_sidebar_active('sidebar-8')):
            ?>
                
                <div id="all-content-below">
                
                    <span class="all-content-below-widget-block">
                        <?php dynamic_sidebar('sidebar-8'); ?>
                    </span>
                
                </div> <!-- id="all-content-below" -->
            
            <?php
            endif;
            ?>
    
            
        </div> <!-- id="content" -->
        
	<!--</div>--> <!-- post_class -->        
        
	<?php 
    if (!hmt4_get_option('hmt_no_sidebars_mode')) { 
        get_sidebar(); 
    }
    ?>

<!--
[Footer Above] Below
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

	<?php 
    if (hmt_is_sidebar_active('footer_above')):
    ?>

        <div id="footer-above">
            <ul class="footer-above-widget-block">
                <?php dynamic_sidebar('footer_above'); ?> 
            </ul>
        </div> <!-- id="footer-above" -->
            
        <div class="clearFloat"></div>
    
    <?php 
    endif;
    ?>

  </div> <!-- id="page-body-wrapper" -->
</div> <!-- end of  id="post... -->


<?php get_footer(); ?>
	


<!--
End of single.php 
~~~ -->
