<?php 
/* 
This file is part of HeatMap Theme Pro v5
Copyright: Stuart Wider
Website: HeatMapTheme.com
*/
?>


<?php get_header(); ?>

<!-- 
search.php
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->
		
<!--
Content of the page (inc comments and post details)
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

<div id="page-body-wrapper">

	<div id="content">
		
		<div class="post-content">
		
<!--
Widget Area: [All Content] Above 
~~~ -->	
			<?php  
            if (hmt_is_sidebar_active('sidebar-7')):
            ?>
				
                <div id="all-content-above">
				
                    <span class="all-content-above-widget-block">
                        <?php dynamic_sidebar('sidebar-7'); ?>
                    </span>
                
                </div> <!-- id="all-content-above" -->
            
            <?php
			endif;
			$all_content_above_already_shown = TRUE;  //so the ads don't get shown twice when the results are returned
			?>
				
			<?php 
			if (have_posts()) : /* changed code to sanitise search results text */
								/* Now html codes entered in the search box will pass through but not be translated as html */
								/* *Thanks* for the tip Joseph Scott */ ?>
				<h2 class="h2-simulate-h1-size-underline"><?php _e('Search Results','hmth'); ?>: <?php echo esc_html(get_search_query(),1);  /* this is the search term */ ?> </h2> 
			<?php
			else: ?>
				<h2 class="h2-simulate-h1-size-underline"><?php _e('No Search Results for','hmth'); ?> <?php echo esc_html(get_search_query(),1); /* this is the search term */ ?> </h2> 
				<p><strong><?php _e('Maybe','hmth'); ?></strong> <?php _e('you can find what you are looking for in one of these places...','hmth'); ?></p>
				
				<?php get_template_part("common-sitemap");
			endif; ?> 
		  
		</div> <!-- class="post-content" -->
		
		<?php 
		get_template_part("common"); 
		?>
	
<!--
Widget Area: [All Content] Below
~~~ -->
		<?php
        if (hmt_is_sidebar_active('sidebar-8')):
        ?>
            
            <div id="all-content-below">
            
                <span class="all-content-below-widget-block">
                    <?php dynamic_sidebar('sidebar-8'); ?>
                </span>
            
            </div> <!-- id="all-content-below" -->
        
        <?php
        endif;
        ?>    

	<div class="post-nav"><p><?php posts_nav_link(); ?></p></div> 
    	
	</div> <!-- id="content" -->
	
	<?php 
	if (!hmt4_get_option('hmt_no_sidebars_mode')) { 
		get_sidebar(); 
	}
	?>
    
<!--
[Footer Above] Below
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

	<?php 
    if (hmt_is_sidebar_active('footer_above')):
    ?>

        <div id="footer-above">
            <ul class="footer-above-widget-block">
            	<?php dynamic_sidebar('footer_above'); ?> 
            </ul>
        </div> <!-- id="footer-above" -->
            
        <div class="clearFloat"></div>
    
    <?php 
    endif;
    ?>    

</div> <!-- id="page-body-wrapper" -->
	
<?php get_footer(); ?>
	

<!--
End of search.php
~~~ -->