<?php
/* 
This file is part of HeatMap Theme Pro v5
Copyright: Stuart Wider
Website: HeatMapTheme.com
*/

/* Set up Option Menu Variables
-------------------------------------------------------------- */
function hmt_set_up_vars() {
	
	global $themename, $shortname, $options, $baseversion, $thisversion, $subtitle,  $hmt_theme_init, $heatmap_link;
	
	$hmt_theme_init = array();
	
	$options = array (
					  			  


/* Adsense Ad Units (Max 3 Google Ad Units Per Page)
-------------------------------------------------------------- */

		array( "type" => "ad-combo-open"),
		
		array(	"name" => __("Ad Units",'hmth'),
				"id" => $shortname."_ad_t1",
				"type" => "ad-combo-title"),
									
		array(	"name" => __("Adsense Unit 1",'hmth'),
				"desc" => "",
				"id" => $shortname."_ad_unit_1",
				"slug" => $shortname."-widget-ad-unit-1",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_ad_unit_1",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),
				"type" => "ad-combo"),
		
		array(	"name" => __("Adsense Unit 2",'hmth'),
				"desc" => "",
				"id" => $shortname."_ad_unit_2",
				"slug" => $shortname."-widget-ad-unit-2",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_ad_unit_2",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),
				"type" => "ad-combo"),	
		
		array(	"name" => __("Adsense Unit 3",'hmth'),
				"desc" => "",
				"id" => $shortname."_ad_unit_3",
				"slug" => $shortname."-widget-ad-unit-3",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_ad_unit_3",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
		
		array( "type" => "ad-combo-close"),
				

/* Adsense Link Units (Max 3 Google Link Units Per Page)
-------------------------------------------------------------- */

		array( "type" => "ad-combo-open"),
		
		array(	"name" => __("Link Units",'hmth'),
				"id" => $shortname."_ad_t2",
				"type" => "ad-combo-title"),
		
		array(	"name" => __("Adsense Link Unit 1",'hmth'),
				"desc" => "",
				"id" => $shortname."_link_unit_1",
				"slug" => $shortname."-widget-link-unit-1",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_link_unit_1",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
	
		array(	"name" => __("Adsense Link Unit 2",'hmth'),
				"desc" => "",
				"id" => $shortname."_link_unit_2",
				"slug" => $shortname."-widget-link-unit-2",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_link_unit_2",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
		
		array(	"name" => __("Adsense Link Unit 3",'hmth'),
				"desc" => "",
				"id" => $shortname."_link_unit_3",
				"slug" => $shortname."-widget-link-unit-3",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_link_unit_3",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
		
		array( "type" => "ad-combo-close"),
				
				
/* Additional Ad Units 1-5
-------------------------------------------------------------- */
				
		array( "type" => "ad-combo-open"),
		
		array(	"name" => __("Additional Ad Units 1-5",'hmth'),
				"id" => $shortname."_ad_t3",
				"type" => "ad-combo-title"),

		
		array(	"name" => __("Additional Ad Unit 1",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_1",
				"slug" => $shortname."-widget-additional-unit-1",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_1",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
	
		array(	"name" => __("Additional Ad Unit 2",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_2",
				"slug" => $shortname."-widget-additional-unit-2",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_2",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
		
		array(	"name" => __("Additional Ad Unit 3",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_3",
				"slug" => $shortname."-widget-additional-unit-3",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_3",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
		
		array(	"name" => __("Additional Ad Unit 4",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_4",
				"slug" => $shortname."-widget-additional-unit-4",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_4",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	

		array(	"name" => __("Additional Ad Unit 5",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_5",
				"slug" => $shortname."-widget-additional-unit-5",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_5",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array( "type" => "ad-combo-close"),
				
				
/* Additional Ad Units 6-10
-------------------------------------------------------------- */
				
		array( "type" => "ad-combo-open"),
		
		array(	"name" => __("Additional Ad Units 6-10",'hmth'),
				"id" => $shortname."_ad_t4",
				"type" => "ad-combo-title"),
		
		array(	"name" => __("Additional Ad Unit 6",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_6",
				"slug" => $shortname."-widget-additional-unit-6",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_6",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array(	"name" => __("Additional Ad Unit 7",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_7",
				"slug" => $shortname."-widget-additional-unit-7",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_7",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array(	"name" => __("Additional Ad Unit 8",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_8",
				"slug" => $shortname."-widget-additional-unit-8",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_8",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array(	"name" => __("Additional Ad Unit 9",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_9",
				"slug" => $shortname."-widget-additional-unit-9",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_9",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array(	"name" => __("Additional Ad Unit 10",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_10",
				"slug" => $shortname."-widget-additional-unit-10",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_10",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array( "type" => "ad-combo-close"),

/* Additional Ad Units 11-15
-------------------------------------------------------------- */				

		array( "type" => "ad-combo-open"),
				
		array(	"name" => __("Additional Ad Units 11-15",'hmth'),
				"id" => $shortname."_ad_t5",
				"type" => "ad-combo-title"),
				
		array(	"name" => __("Additional Ad Unit 11",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_11",
				"slug" => $shortname."-widget-additional-unit-11",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_11",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array(	"name" => __("Additional Ad Unit 12",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_12",
				"slug" => $shortname."-widget-additional-unit-12",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_12",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array(	"name" => __("Additional Ad Unit 13",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_13",
				"slug" => $shortname."-widget-additional-unit-13",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_13",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array(	"name" => __("Additional Ad Unit 14",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_14",
				"slug" => $shortname."-widget-additional-unit-14",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_14",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array(	"name" => __("Additional Ad Unit 15",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_15",
				"slug" => $shortname."-widget-additional-unit-15",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_15",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array( "type" => "ad-combo-close"),		

/* Additional Ad Units 16-20
-------------------------------------------------------------- */		
				
		array( "type" => "ad-combo-open"),

		array(	"name" => __("Additional Ad Units 16-20",'hmth'),
				"id" => $shortname."_ad_t6",
				"type" => "ad-combo-title"),
				
		array(	"name" => __("Additional Ad Unit 16",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_16",
				"slug" => $shortname."-widget-additional-unit-16",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_16",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array(	"name" => __("Additional Ad Unit 17",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_17",
				"slug" => $shortname."-widget-additional-unit-17",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_17",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array(	"name" => __("Additional Ad Unit 18",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_18",
				"slug" => $shortname."-widget-additional-unit-18",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_18",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array(	"name" => __("Additional Ad Unit 19",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_19",
				"slug" => $shortname."-widget-additional-unit-19",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_19",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
				
		array(	"name" => __("Additional Ad Unit 20",'hmth'),
				"desc" => "",
				"id" => $shortname."_additional_unit_20",
				"slug" => $shortname."-widget-additional-unit-20",
				"widgetdesc" => __("Ad Unit",'hmth') . " (HeatMap Theme v" . $baseversion . ")",
				"function" => $shortname. "_widget_additional_unit_20",
				"std" => "",
				"userguide" => "adsense-ad-and-link-units",
				"checkbox" => array( "Home" => "",
									 "Page" => "",
									 "Post" => "",
									 "Category" => "",
									 "Search" => "",
									 "Archive" => ""),

				"type" => "ad-combo"),	
		
		array( "type" => "ad-combo-close"),
			
				
/* Home Page
-------------------------------------------------------------- */

		array( "type" => "open"),
	
		array(	"name" => __("Home Page",'hmth'),
				"id" => $shortname."_t1",
				"type" => "title"),
		
		array(	"name" => __("Featured Page",'hmth'),
				"desc" => "",
				"id" => $shortname."_featured",
				"std" => "",
				"userguide" => "featured-page-id",
				"type" => "text"),
				
		array(	"name" => __("Full Width Featured Page",'hmth'),
				"desc" => "",
				"id" => $shortname."_featured_full",
				"std" => "checked",
				"userguide" => "full-width-featured-page",
				"type" => "checkbox"),

		array(	"name" => __("Hide Sidebar",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_home_sidebar",
				"std" => "checked",
				"userguide" => "hide-home-sidebar",
				// "type" => "select-posts-sidebar-style"),
				"type" => "checkbox"),
				
		array(	"name" => __("Hide Featured Page Title",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_featured_page_title",
				"std" => "checked",
				"userguide" => "hide-featured-page-titles",
				"type" => "checkbox"),

		array(	"name" => __("Hide Featured Page Details",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_featured_page_detail",
				"std" => "checked",
				"userguide" => "hide-featured-page-detail",
				"type" => "checkbox"),

				
		array(	"name" => __("Hide Posts",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_recent_posts",
				"std" => "checked",
				"userguide" => "hide-home-posts",
				// "type" => "select-posts-sidebar-style"),
				"type" => "checkbox"),
				
				
		array(	"name" => __("Hide Post Details",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_details_for_home",
				"std" => "checked",
				"userguide" => "hide-details",
				"type" => "checkbox"),
				
		array(	"name" => __("Hide Post Comments #",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_comments_for_home",
				"std" => "checked",
				"userguide" => "hide-home-post-comments",
				"type" => "checkbox"),
	
				
		array(	"name" => __("Auto Excerpt Length (words)",'hmth'),
				"desc" => "",
				"id" => $shortname."_auto_excerpt_length",
				"std" => "",
				"userguide" => "auto-excerpt",
				"type" => "short-text"),
		
		array(	"name" => __("Include Post Categories",'hmth'),
				"desc" => "",
				"id" => $shortname."_include_cat_home_post",
				"std" => "",
				"userguide" => "include-cat-from-home",
				"type" => "multi-select"),
		
		array( "type" => "close"),
		
/* SEO
-------------------------------------------------------------- */

		array( "type" => "open"),
	
		array(	"name" => __("SEO",'hmth'),
				"id" => $shortname."_t2",
				"type" => "title"),

		array(	"name" => __("SEO Plugin",'hmth'),
				"desc" => "",
				"id" => $shortname."_seo_plugin",
				"std" => "",
				"userguide" => "seo-plugin",
				"type" => "checkbox"),
				
		array(	"name" => __("Home Page Meta Description",'hmth'),
				"desc" => "",
				"id" => $shortname."_meta_description",
				"std" => "",
				"userguide" => "meta-description",
				"type" => "textarea"),
		
		array(	"name" => __("Home Page Meta Keywords",'hmth'),
				"desc" => "",
				"id" => $shortname."_meta_keywords",
				"std" => "",
				"userguide" => "meta-keywords",
				"type" => "textarea"),	
								
		array(	"name" => __("Assign Home Page H1 Tag",'hmth'),
				"desc" => "",
				"id" => $shortname."_h1_setting",
				"std" => "",
				"userguide" => "assign-h1-page-tag",
				"type" => "select-h1"),
				
		array(	"name" => __("Assign H2 to Page Titles",'hmth'),
				"desc" => "",
				"id" => $shortname."_assign_h2_page_titles",
				"std" => "checked",
				"userguide" => "assign-h2-page-post-titles",
				"type" => "checkbox"),
				
		array(	"name" => __("Assign H2 to Post Titles",'hmth'),
				"desc" => "",
				"id" => $shortname."_assign_h2_post_titles",
				"std" => "checked",
				"userguide" => "assign-h2-page-post-titles",
				"type" => "checkbox"),
							
		array(	"name" => __("Home Page SEO Text",'hmth'),
				"desc" => "",
				"id" => $shortname."_seo_text",
				"std" => "",
				"userguide" => "seo-text",
				"type" => "textarea"),
				
		array(	"name" => __("Indexing",'hmth'),
				"desc" => "",
				"id" => $shortname."_indexing",
				"std" => "",
				"userguide" => "indexing",
				"type" => "select-indexing"),
		
		array( "type" => "close"),
				

/* Theme Structure
-------------------------------------------------------------- */

		array( "type" => "open"),
		
		array(	"name" => __("Theme Structure",'hmth'),
				"id" => $shortname."_t3",
				"type" => "title"),	
				
		array(	"name" => __("Activate Squeeze Mode",'hmth'),
				"desc" => "",
				"id" => $shortname."_squeeze_mode",
				"std" => "checked",
				"userguide" => "squeeze-mode",
				"type" => "checkbox"),
				
		array(	"name" => __("Activate No Sidebars Mode",'hmth'),
				"desc" => "",
				"id" => $shortname."_no_sidebars_mode",
				"std" => "checked",
				"userguide" => "no-sidebars-mode",
				"type" => "checkbox"),
				
		array(	"name" => __("Switch Sidebar Left or Right",'hmth'),
				"desc" => "",
				"id" => $shortname."_left_or_right",
				"std" => "",
				"userguide" => "left-right",
				"options" => array( 'RIGHT', 'LEFT'),
				"type" => "select-left-right"),
				
		array( "type" => "close"),
		

/* Header Bar
-------------------------------------------------------------- */

		array( "type" => "open"),
		
		array(	"name" => __("Header and Logo",'hmth'),
				"id" => $shortname."_t4",
				"type" => "title"),
			
		array(	"name" => __("Logo URL",'hmth'),
				"desc" => "",
				"id" => $shortname."_logo_url",
				"std" => "",
				"userguide" => "logo-url",
				"type" => "text"),
				
		array(	"name" => __("Logo ALT text description",'hmth'),
				"desc" => "",
				"id" => $shortname."_alt_text",
				"std" => "",
				"userguide" => "logo-alt",
				"type" => "text"),
				
		array(	"name" => __("Favicon URL",'hmth'),
				"desc" => "",
				"id" => $shortname."_favicon_url",
				"std" => "",
				"userguide" => "favicon-url",
				"type" => "text"),
				

				
		array(	"name" => __("Hide Header",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_header",
				"std" => "",
				"userguide" => "hide-header",
				"type" => "checkbox"),
				
		array(	"name" => __("Hide Title and Tagline",'hmth'),
				"desc" => "",
				"id" => $shortname."_show_title_and_tagline",
				"std" => "checked",
				"userguide" => "title-and-tagline",
				"type" => "checkbox"),
		
		array( "type" => "close"),



/* Navigation
-------------------------------------------------------------- */

		array( "type" => "open"),
	
		array(	"name" => __("Navigation",'hmth'),
				"id" => $shortname."_t5",
				"type" => "title"),		
				
		array(	"name" => __("Navigation Style",'hmth'),
				"desc" => "",
				"id" => $shortname."_header_navigation_style",
				"std" => "checked",
				"userguide" => "header-navigation-style",
				"type" => "select-nav-style"),
				
		array(	"name" => __("Search Position",'hmth'),
				"desc" => "",
				"id" => $shortname."_search_position",
				"std" => "checked",
				"userguide" => "search-position",
				"type" => "select-search-social-rss-position"),	
		
			
		array(	"name" => __("Pages to Exclude",'hmth'),
				"desc" => "",
				"id" => $shortname."_exclude_pages",
				"std" => "",
				"userguide" => "page-id-exclusion",
				"type" => "text"),
				
		array(	"name" => __("Categories to Exclude",'hmth'),
				"desc" => "",
				"id" => $shortname."_exclude_categories",
				"std" => "",
				"userguide" => "category-id-exclusion",
				"type" => "text"),
				
		array(	"name" => __("Hide Page Navigation Bar",'hmth'),
				"desc" => "",
				"id" => $shortname."_show_nav_bar",
				"std" => "checked",
				"userguide" => "hide-nav-cat-bar",
				"type" => "checkbox"),
					
		array(	"name" => __("Hide Categories Navigation Bar",'hmth'),
				"desc" => "",
				"id" => $shortname."_show_cat_bar",
				"std" => "checked",
				"userguide" => "hide-nav-cat-bar",
				"type" => "checkbox"),
				
		array(	"name" => __("Hide Search",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_search",
				"std" => "checked",
				"userguide" => "hide-search",
				"type" => "checkbox"),					
		
		array( "type" => "close"),
		
	
/* Post Content, Details and Comment Settings
-------------------------------------------------------------- */
		
		array( "type" => "open"),
		
		array(	"name" => __("Pages and Posts",'hmth'),
				"id" => $shortname."_t6",
				"type" => "title"),

		array(	"name" => __("Pages",'hmth'),
				"type" => "suboptions"),
		
		array(	"name" => __("Hide Titles",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_page_titles",
				"std" => "checked",
				"userguide" => "hide-page-titles",
				"type" => "checkbox"),
				
		array(	"name" => __("Hide Details",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_details_for_pages",
				"std" => "checked",
				"userguide" => "hide-details",
				"type" => "checkbox"),
				
		array(	"name" => __("Hide Comments #",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_comments_for_pages",
				"std" => "checked",
				"userguide" => "hide-details",
				"type" => "checkbox"),
								
/*		array( "type" => "close"),
		array( "type" => "open"),
*/	

		array(	"name" => __("Posts",'hmth'),
				"type" => "suboptions"),
				
		array(	"name" => __("Hide Titles",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_post_titles",
				"std" => "checked",
				"userguide" => "hide-post-titles",
				"type" => "checkbox"),

		array(	"name" => __("Hide Details",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_details_for_posts",
				"std" => "checked",
				"userguide" => "hide-details",
				"type" => "checkbox"),
				
		array(	"name" => __("Hide Comments #",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_comments_for_posts",
				"std" => "checked",
				"userguide" => "hide-details",
				"type" => "checkbox"),
				
/*		array( "type" => "close"),
		array( "type" => "open"),
*/					
		array(	"name" => __("Categories",'hmth'),
				"type" => "suboptions"),
					
		array(	"name" => __("Hide Details",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_details_for_categories",
				"std" => "checked",
				"userguide" => "hide-details",
				"type" => "checkbox"),
				
		array(	"name" => __("Hide Comments #",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_comments_for_categories",
				"std" => "checked",
				"userguide" => "hide-details",
				"type" => "checkbox"),

/*		array( "type" => "close"),
		array( "type" => "open"),
*/					
		array(	"name" => __("Search",'hmth'),
				"type" => "suboptions"),
					
		array(	"name" => __("Hide Details",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_details_for_search",
				"std" => "checked",
				"userguide" => "hide-details",
				"type" => "checkbox"),
				
		array(	"name" => __("Hide Comments #",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_comments_for_search",
				"std" => "checked",
				"userguide" => "hide-details",
				"type" => "checkbox"),
				
/*		array( "type" => "close"),
		array( "type" => "open"),
*/					
		array(	"name" => __("Archives",'hmth'),
				"type" => "suboptions"),
					
		array(	"name" => __("Hide Details",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_details_for_archives",
				"std" => "checked",
				"userguide" => "hide-details",
				"type" => "checkbox"),
		
		array(	"name" => __("Hide Comments #",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_comments_for_archives",
				"std" => "checked",
				"userguide" => "hide-details",
				"type" => "checkbox"),
				
				
/*		array( "type" => "close"),
		array( "type" => "open"),
*/			
		array(	"name" => __("Title Safety",'hmth'),
				"type" => "suboptions"),

		array(	"name" => __("Activate Title Safety Underlining",'hmth'),
				"desc" => "",
				"id" => $shortname."_underline_post_titles",
				"std" => "checked",
				"userguide" => "underline-post-titles",
				"type" => "checkbox"),
				
		array(	"name" => __("Titles inline with [Content Item] Left/Right",'hmth'),
				"desc" => "",
				"id" => $shortname."_inline_blog_titles",
				"std" => "checked",
				"userguide" => "inline-blog-titles",
				"type" => "checkbox"),
				
/*		This is an experimental setting - I've left it here so adventurous types can try it ;)

		array(	"name" => __("Titles flow with [Content Item] Left/Right",'hmth'),
				"desc" => "",
				"id" => $shortname."_flow_blog_titles",
				"std" => "checked",
				"userguide" => "inline-blog-titles",
				"type" => "checkbox"),
*/

		array( "type" => "close"),
		
/* HeatMap Theme Footers
-------------------------------------------------------------- */	

		array( "type" => "open"),
	
		array(	"name" => __("Footers",'hmth'),
				"id" => $shortname."_t7",
				"type" => "title"),
		
		array(	"name" => __("Footer Left",'hmth'),
				"desc" => "",
				"id" => $shortname."_footer_left",
				"std" => "",
				"userguide" => "footer-bar",
				"type" => "textarea"),	
		
		array(	"name" => __("Footer Right",'hmth'),
				"desc" => "",
				"id" => $shortname."_footer_right",
				"std" => "",
				"userguide" => "footer-bar",
				"type" => "textarea"),	
		
		array(	"name" => __("Subfooter Left",'hmth'),
				"desc" => "",
				"id" => $shortname."_subfooter_left",
				"std" => "",
				"userguide" => "footer-bar",
				"type" => "textarea"),	
		
		array(	"name" => __("Subfooter Right",'hmth'),
				"desc" => __("You can change this credit link to something else. If you decide to retain it we say thanks!",'hmth'),
				"id" => $shortname."_subfooter_right",
				"std" => "WordPress Theme by <a href=\"http://heatmaptheme.com\">HeatMapTheme.com</a>",
				"userguide" => "footer-bar",
				"type" => "textarea"),	
					
		array(	"name" => __("Hide Footer",'hmth'),
				"desc" => "",
				"id" => $shortname."_show_footer_bar",
				"std" => "checked",
				"userguide" => "hide-footer-bar",
				"type" => "checkbox"),
		
		array(	"name" => __("Hide Sub Footer",'hmth'),
				"desc" => "",
				"id" => $shortname."_show_subfooter_bar",
				"std" => "checked",
				"userguide" => "hide-footer-bar",
				"type" => "checkbox"),
	
		array( "type" => "close"),


/* Thumbnail Settings
-------------------------------------------------------------- */	

		array( "type" => "open"),
		
		array(	"name" => __("Featured Images",'hmth'),
				"id" => $shortname."_t8",
				"type" => "title"),

		array(	"name" => __("Homepage, Categories, Tags &amp; Archives",'hmth'),
				"desc" => "",
				"id" => $shortname."_common_thumbnail_left_or_right",
				"std" => "",
				"userguide" => "featured-images",
				// "options" => array( 'RIGHT', 'LEFT', 'OFF'),
				"type" => "select-left-right-off"),
		
		array(	"name" => __("Pages",'hmth'),
				"desc" => "",
				"id" => $shortname."_page_thumbnail_left_or_right",
				"std" => "",
				"userguide" => "featured-images",
				// "options" => array( 'RIGHT', 'LEFT', 'OFF'),
				"type" => "select-left-right-off"),
		
		array(	"name" => __("Posts",'hmth'),
				"desc" => "",
				"id" => $shortname."_post_thumbnail_left_or_right",
				"std" => "",
				"userguide" => "featured-images",
				//"options" => array( 'RIGHT', 'LEFT', 'OFF'),
				"type" => "select-left-right-off"),

		array( "type" => "close"),



/* Recent Post Plus Settings
-------------------------------------------------------------- */	

		//array( "type" => "open"),
		
		array(	"name" => __("Widgets",'hmth'),
				"id" => $shortname."_t9",
				"type" => "exclude-from-options"),
								
		array(	"name" => __("Recent Posts Plus widget title",'hmth'),
				"desc" => "",
				"id" => $shortname."_recent_posts_plus_title",
				"std" => "",
				"userguide" => "recent-posts-plus",
				"type" => "exclude-from-options"),

		array(	"name" => __("Number of recent posts to display",'hmth'),
				"desc" => "",
				"id" => $shortname."_recent_posts_plus_num",
				"std" => "",
				"userguide" => "recent-posts-plus",
				"type" => "exclude-from-options"),
				
		array(	"name" => __("Exclude category from recent post",'hmth'),
				"desc" => "",
				"id" => $shortname."_recent_posts_exclude_cat",
				"std" => "",
				"userguide" => "recent-posts-plus-exclude-cat",
				"type" => "exclude-from-options"),
				
		array(	"name" => __("Auto excerpt length for recent post",'hmth'),
				"desc" => "",
				"id" => $shortname."_auto_excert_len_recent_post",
				"std" => "",
				"userguide" => "auto-excert-len-recent-post",
				"type" => "exclude-from-options"),
				
		array(	"name" => __("Social Icons widget title",'hmth'),
				"desc" => "",
				"id" => $shortname."_social_icons_title",
				"std" => "",
				"userguide" => "social-icons-widget",
				"type" => "exclude-from-options"),

		array(	"name" => __("Feedburner widget title",'hmth'),
				"desc" => "",
				"id" => $shortname."_feedburner_title",
				"std" => "",
				"userguide" => "feedburner-widget-title",
				"type" => "exclude-from-options"),

		//array( "type" => "close"),
		
		
/* Google
-------------------------------------------------------------- */

		array( "type" => "open"),
		
		array(	"name" => __("Google",'hmth'),
				"id" => $shortname."_t10",
				"type" => "title"),
	
		array(	"name" => __("CSE Search Code",'hmth'),
				"desc" => "",
				"id" => $shortname."_google_search",
				"std" => "",
				"userguide" => "google-adsense-custom-search",
				"type" => "textarea"),
		
		array(	"name" => __("CSE Results Code",'hmth'),
				"desc" => "",
				"id" => $shortname."_google_results",
				"std" => "",
				"userguide" => "google-adsense-custom-search",
				"type" => "textarea"),
				
		array(	"name" => __("Analytics Tracker Code",'hmth'),
				"desc" => "",
				"id" => $shortname."_google_analytics",
				"std" => "",
				"userguide" => "google-analytics",
				"type" => "textarea"),	
		
		array( "type" => "close"),
		
	
		
/* Social
-------------------------------------------------------------- */

		array( "type" => "open"),
		
		array(	"name" => __("Social Network Icons",'hmth'),
				"id" => $shortname."_t11",
				"type" => "title"),		

		array(	"name" => __("RSS/Social Icons Position",'hmth'),
				"desc" => "",
				"id" => $shortname."_rss_social_position",
				"std" => "checked",
				"userguide" => "rss-social-position",
				"type" => "select-search-social-rss-position"),	
						
		array(	"name" => __("FeedBurner ID",'hmth'),
				"desc" => "",
				"id" => $shortname."_feedburner_id",
				"std" => "",
				"userguide" => "feedburner-subscription",
				"type" => "text"),
		
		array(	"name" => __("FeedBurner Comments ID",'hmth'),
				"desc" => "",
				"id" => $shortname."_feedburner_comments_id",
				"std" => "",
				"userguide" => "feedburner-subscription",
				"type" => "text"),
	

			
		array(	"name" => __("Facebook ID",'hmth'),
				"desc" => "",
				"id" => $shortname."_facebook_id",
				"std" => "",
				"userguide" => "social-icons",
				"type" => "text"),

		array(	"name" => __("Twitter ID",'hmth'),
				"desc" => "",
				"id" => $shortname."_twitter_id",
				"std" => "",
				"userguide" => "social-icons",
				"type" => "text"),	
				
		array(	"name" => __("MySpace ID",'hmth'),
				"desc" => "",
				"id" => $shortname."_myspace_id",
				"std" => "",
				"userguide" => "social-icons",
				"type" => "text"),	
				
		array(	"name" => __("You Tube ID",'hmth'),
				"desc" => "",
				"id" => $shortname."_youtube_id",
				"std" => "",
				"userguide" => "social-icons",
				"type" => "text"),	
				
		array(	"name" => __("LinkedIn Public Profile",'hmth'),
				"desc" => "",
				"id" => $shortname."_linkedin_id",
				"std" => "",
				"userguide" => "social-icons",
				"type" => "text"),
				
		array(	"name" => __("Google+ Profile URL",'hmth'),
				"desc" => "",
				"id" => $shortname."_googleplus",
				"std" => "",
				"userguide" => "social-icons",
				"type" => "text"),

		array(	"name" => __("Add Google One Plus Button",'hmth'),
				"desc" => "",
				"id" => $shortname."_add_google_one",
				"std" => "checked",
				"userguide" => "like-buttons",
				"type" => "checkbox"),	
				
		array(	"name" => __("Add Twitter Tweet Button",'hmth'),
				"desc" => "",
				"id" => $shortname."_add_twitter_tweet",
				"std" => "checked",
				"userguide" => "like-buttons",
				"type" => "checkbox"),	
				
		array(	"name" => __("Add Facebook Like Button",'hmth'),
				"desc" => "",
				"id" => $shortname."_add_facebook_like",
				"std" => "checked",
				"userguide" => "like-buttons",
				"type" => "checkbox"),		
				
		array(	"name" => __("Hide all RSS/Social Icons",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_rss",
				"std" => "checked",
				"userguide" => "hide-rss",
				"type" => "checkbox"),	
				
		array(	"name" => __("Hide RSS Feed Icon",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_rss_icon",
				"std" => "checked",
				"userguide" => "hide-rss",
				"type" => "checkbox"),	

		array(	"name" => __("Hide RSS Comments Feed Icon",'hmth'),
				"desc" => "",
				"id" => $shortname."_hide_rss_comments_icon",
				"std" => "checked",
				"userguide" => "hide-rss",
				"type" => "checkbox"),		
		
		array( "type" => "close"),
				
		
/* Header and Footer Locking
-------------------------------------------------------------- */
		
		array( "type" => "open"),
			
		array(	"name" => __("Header and Footer Locking",'hmth'),
				"id" => $shortname."_t12",
				"type" => "title"),
				
		array(	"name" => __("Header Lock",'hmth'),
				"desc" => "",
				"id" => $shortname."_header_lock",
				"std" => "checked",
				"userguide" => "header-footer-locking",
				"type" => "select-header-lock"),
				
		array(	"name" => __("Header Lock Offset",'hmth'),
				"desc" => "",
				"id" => $shortname."_header_lock_offset",
				"std" => "",
				"userguide" => "header-footer-locking",
				"type" => "short-text"),
				
		array(	"name" => __("Display [Header] Lock Bar",'hmth'),
				"desc" => "",
				"id" => $shortname."_display_header_lock_bar",
				"std" => "checked",
				"userguide" => "header-footer-locking",
				"type" => "checkbox"),
				
		array(	"name" => __("Display [Sub Header] Lock Bar",'hmth'),
				"desc" => "",
				"id" => $shortname."_display_sub_header_lock_bar",
				"std" => "checked",
				"userguide" => "header-footer-locking",
				"type" => "checkbox"),
				
		array(	"name" => __("Footer Lock",'hmth'),
				"desc" => "",
				"id" => $shortname."_footer_lock",
				"std" => "checked",
				"userguide" => "header-footer-locking",
				"type" => "select-footer-lock"),
				
		array(	"name" => __("Footer Lock Offset",'hmth'),
				"desc" => "",
				"id" => $shortname."_footer_lock_offset",
				"std" => "",
				"userguide" => "header-footer-locking",
				"type" => "short-text"),
				
		array(	"name" => __("Display [Footer] Lock Bar",'hmth'),
				"desc" => "",
				"id" => $shortname."_display_footer_lock_bar",
				"std" => "checked",
				"userguide" => "header-footer-locking",
				"type" => "checkbox"),
				
		array(	"name" => __("Display [Sub Footer] Lock Bar",'hmth'),
				"desc" => "",
				"id" => $shortname."_display_sub_footer_lock_bar",
				"std" => "checked",
				"userguide" => "header-footer-locking",
				"type" => "checkbox"),
				
		array( "type" => "close"),	
		
				
		
/* Additional <HEAD> Scripts
-------------------------------------------------------------- */

		array( "type" => "open"),
		
		array(	"name" => __("Additional Scripts and CSS",'hmth'),
				"id" => $shortname."_t13",
				"type" => "title"),
		
		array(	"name" => __("Head Scripts",'hmth'),
				"desc" => "",
				"id" => $shortname."_head_scripts",
				"std" => "",
				"userguide" => "head-scripts",
				"type" => "textarea"),	

		array(	"name" => __("Head CSS",'hmth'),
				"desc" => "",
				"id" => $shortname."_head_css",
				"std" => "",
				"userguide" => "head-css",
				"type" => "textarea-full"),	
		
		array( "type" => "close")


					
	);
}
?>