<?php
/*
Plugin Name: SEOPressor V4
Plugin URI: http://www.SEOPressor.com
Description: Daniel Tan's Popular SEOPressor automatically optimizes your on-page SEO to hit top search engine rankings. Read <a href="http://www.warriorforum.com/warrior-special-offers-forum/177482-4-340-high-google-pagerank-backlinks-built-automatically-backlink-syndication-system-launched-grab-cheap.html">The Backlink Syndication System</a> if you want a  lot of backlinks. Make money with SEOPressor by adding your ClickBank ID into SEOPressor footer link (in settings). <a href="http://seopressor.com/Affiliates.html">Join our affiliate program here</a>.
Version: 4.3.09
Author: Daniel Tan
Author URI: http://SEOPressor.com/Daniel.html
*/

/**
 * Version of WordPress
 * @global	string	$wp_version
 */
global $wp_version;

$exit_msg = __('This plugin require WordPress 3.1 or newer','seo-pressor').'. <a href="http://codex.wordpress.org/Upgrading_WordPress">'.__('Please update','seo-pressor').'</a>';
if (version_compare($wp_version, "3.1", "<")) { 
	exit($exit_msg);
}

// Avoid name collisions.
if (!class_exists('WPPostsRateKeys')) {
	class WPPostsRateKeys
    {
       /**
	    * The Plugin version
	    * @var string
	    */
        const VERSION = '4.3.09';
         
       /**
	    * The url to the plugin
	    *
	    * @static 
	    * @var string
	    */
        static $plugin_url;
         
       /**
	    * The path to the plugin
	    *
	    * @static 
	    * @var string
	    */
        static $plugin_dir;
        
       /**
	    * The path to the plugin templates files
	    *
	    * @static 
	    * @var string
	    */
        static $template_dir;
        
       /**
         * Executes all initialization code for the plugin.
         * 
         * @return void
         * @access public
		 */
        function WPPostsRateKeys() {
        	
        	// Define static values
        	$dir_name = dirname( plugin_basename(__FILE__) );
        	self::$plugin_url = trailingslashit( WP_PLUGIN_URL . '/' . $dir_name);
        	self::$plugin_dir = trailingslashit( WP_PLUGIN_DIR . '/' . $dir_name);
        	self::$template_dir = self::$plugin_dir . '/templates';
        	
        	// Include all classes
        	include(self::$plugin_dir . '/includes/all_classes.php');
        	
        	// Schedule jobs
			self::add_actions_for_schedule_jobs();
			
			// @version 4.3.04
        	self::update_main_options();
        	
        	// Check is plugin is activated
			if (WPPostsRateKeys_Settings::get_active()) {
				// Add filter to show original content when editing POST content
	        	add_filter('content_edit_pre', array(&$this, 'get_content_to_edit'), 1);
	        	
	        	// Add filter to modify the Post Content before stores it in Database
	        	add_filter('content_save_pre', array(&$this, 'set_content_to_save_in_db'), 1);
	        	
	        	// Add filter for POST content, @version 4.3.06 Set priority=1 Solving(?) duplicated content in Post from others plugins
	        	add_filter('the_content', array(&$this, 'filter_post_content'), 1, 2);
	        	
	        	// Add filter for POST title
	        	add_filter('the_title', array(&$this, 'filter_post_title'), 10, 2);
	        	
	        	// Add actions to handle the Update of a POST or PAGE, in order to store the keyword
	           	add_action('save_post',  array(&$this, 'handle_update_post_form'),11,2);
	           	add_action('save_page',  array(&$this, 'handle_update_post_form'),11,2);
	           	
	           	// Add link in WP footer if user allow it
	           	if (WPPostsRateKeys_Settings::get_allow_seopressor_footer()) {
	           		add_action('wp_footer', array(&$this, 'handle_add_to_footer'));
	           	}
			}
        	
           	// Add Menu Box in Admin Panel
           	add_action('admin_menu', array(&$this, 'admin_menu'));
    
           	// If the plugin isn't activated by Aweber or can be upgrade, show message
           	add_action('admin_notices', array(&$this, 'show_admin_notice'));
           	
           	// If plugin can be upgrade, show message
			add_action("after_plugin_row", array(&$this, 'show_notice_plugins_page'), 10, 2);	
           	
			// Add style
			wp_enqueue_style('seo-style', self::$plugin_url . 'templates/css/styles.css');
			
			// Add the widget in dashboard
			add_action('wp_dashboard_setup', array(&$this, 'add_dashboard_widget'));
			
			// Translations for plugin
			self::handle_load_domain();
			
			// Store cookies pending to save
			WPPostsRateKeys_Cookies::save_cookies_pending_to_save();
        }
        
        /**
         * Add the widget in dashboard
         * 
         * @return void
         * @access public
         */
        function add_dashboard_widget() {
        	
        	wp_add_dashboard_widget('seopressor_dashboard_widget', 'SEOPressor', array(&$this, 'show_dashboard_widget'));
        	
        	// Globalize the metaboxes array, this holds all the widgets for wp-admin
			global $wp_meta_boxes;
			
			// Get the regular dashboard widgets array 
			// (which has our new widget already but at the end)
		
			$normal_dashboard = $wp_meta_boxes['dashboard']['normal']['core'];
			
			// Backup and delete our new dashbaord widget from the end of the array
			$seopressor_dashboard_widget_backup = array('seopressor_dashboard_widget' => $normal_dashboard['seopressor_dashboard_widget']);
			unset($normal_dashboard['seopressor_dashboard_widget']);
		
			// Merge the two arrays together so our widget is at the beginning		
			$sorted_dashboard = array_merge($seopressor_dashboard_widget_backup, $normal_dashboard);
		
			// Save the sorted array back into the original metaboxes
			$wp_meta_boxes['dashboard']['normal']['core'] = $sorted_dashboard;
        }
        
        /**
         * Show the widget in dashboard
         * 
         * @return void
         * @access public
         */
        function show_dashboard_widget() {
        	/*
        	 * This will request the content of the message Box from Central Server.
        	 */        	
        	$result = WPPostsRateKeys_Central::get_specific_data_from_server('dashboard_box_message');
        	
        	include(self::$template_dir . '/includes/dashboard_box.php');
		}
        
        /**
         * Handles the translation of plugin
         * 
         * @return void
         * @access public
		 */
        function handle_load_domain()
		{
			$plugin_domain = 'seo-pressor';
			
			// Get language in use from settings
			$locale = WPPostsRateKeys_Settings::get_locale();
			
			if ($locale!='') {
				// locate translation file
				$mofile = self::$plugin_dir. '/lang/' . $plugin_domain . '-' . $locale . '.mo';
				
				if (file_exists($mofile)) {
					// load translation
					load_textdomain($plugin_domain, $mofile);
				}
			}
		}
		
        /** 
		 * Display box in add/edit post/page page to Show the Score
		 * 
		 * Call for functionality in Central Server
		 * 
		 * @global	$post	POST Object
		 * @return 	void
		 * @access 	public
		 */
        function show_score_box() {
        	global $post;
        	$post_id = $post->ID;
        	
			if (!WPPostsRateKeys_Central::is_cache_valid($post_id)) {
        		$result = WPPostsRateKeys_Central::get_data($post_id);
        	}
			
			// Show include for template
    		include(self::$plugin_dir . '/includes/admin/box_suggestions.php');
        }
        
        /** 
		 * Hooks to show admin notices if requires
		 * 
		 * Only show message when is active
		 * 
		 * @param	string	$links
		 * @param	string	$file
		 * @return 	void
		 * @access 	public
		 */
    	function show_notice_plugins_page($links, $file) {
        	if (substr_count($file['Name'],'SEOPressor') >0 && WPPostsRateKeys_Settings::get_active()==1) {
	        	// Show message only if user fulfill the requirements to upgrade and if versions mismatch
			    if ((version_compare(WPPostsRateKeys_Settings::get_current_version(), WPPostsRateKeys_Settings::get_last_version(), "<"))
			    		&& WPPostsRateKeys_Upgrade::all_checks_for_upgrade()
			    	) {
		        	$msg_error = WPPostsRateKeys_Settings::get_msg_for_new_version();
		        	include( WPPostsRateKeys::$template_dir . '/includes/msg_in_plugins_page.php');
	        	}
        	}
        }
        
        /** 
		 * Hooks to show admin notices if requires
		 * 
		 * @return void
		 * @access public
		 */
        function show_admin_notice() {
        	
	        // If isn't active show message
	        if (WPPostsRateKeys_Settings::get_active()==0) {
        		// Show in all pages except in Setting page when submit activate button
        		if (!isset($_POST['Submit_activation'])) {
	        		$msg_error[] = __('To use SEOPressor Plugin, it has to be activated. To do this, go to ','seo-pressor')
	        					. '<a href="' . get_bloginfo ( 'wpurl' ) . '/wp-admin/admin.php?page=seo-pressor.php#activation_settings">' . __('Activation Settings','seo-pressor') . '</a>';
	        		include( WPPostsRateKeys::$template_dir . '/includes/msg.php');
			        unset($msg_error);
        		}
        	}
        	else { // Only check this if the plugin is active
        		
	        	/*
        		 * Show upgrade message
        		 */
        		// If isn't the plugins page
        		if (substr_count($_SERVER['REQUEST_URI'], 'wp-admin/plugins.php')==0) {
	        		// If isn't the upgrade page
	        		if ( !(isset($_GET['page']) && $_GET['page']=='seopressor-auto-upgrade')) {
	        			// Show message only if user fulfill the requirements to upgrade and if versions mismatch
			        	if ((version_compare(WPPostsRateKeys_Settings::get_current_version(), WPPostsRateKeys_Settings::get_last_version(), "<"))
			        		&&  WPPostsRateKeys_Upgrade::all_checks_for_upgrade()
			        	) {
				        	$msg_error[] = WPPostsRateKeys_Settings::get_msg_for_new_version();
				        	include( WPPostsRateKeys::$template_dir . '/includes/msg.php');
				        	unset($msg_error);
			        	}
	        		}
        		}
        	}
        }	
        
        /** 
		 * Hooks the add of the main menu
		 * 
		 * @return void
		 * @access public
		 */
        function admin_menu() {
        	add_menu_page(__('SEOPressor','seo-pressor'), __('SEOPressor','seo-pressor'), 'manage_options', basename(__FILE__), array(&$this, 'handle_admin_general_settings'));
			
            add_submenu_page(basename(__FILE__), __('Settings','seo-pressor'), __('Settings','seo-pressor'), 'manage_options', basename(__FILE__), array(&$this, 'handle_admin_general_settings'));
            add_submenu_page(basename(__FILE__), '', '', 'manage_options', 'seopressor-auto-upgrade', array(&$this, 'handle_admin_menu_auto_upgrade'));
            add_submenu_page(basename(__FILE__), __('POSTs Score','seo-pressor'), __('POSTs Score','seo-pressor'), 'manage_options', 'seopressor-posts-score', array(&$this, 'handle_admin_menu_posts_rate'));
            add_submenu_page(basename(__FILE__), '', '', 'manage_options', 'seopressor-suggestions', array(&$this, 'handle_admin_menu_suggestions'));
            add_submenu_page(basename(__FILE__), __('PAGEs Score','seo-pressor'), __('PAGEs Score','seo-pressor'), 'manage_options', 'seopressor-pages-score', array(&$this, 'handle_admin_menu_pages_rate'));
            
            // Add custom panel for edit post and pages
	        // Check is plugin is activated
			if (WPPostsRateKeys_Settings::get_active()) {				
				// Add box in add/edit post/page page to Show the Score
	           	add_meta_box( 'seo_pressor_post_suggestions', 'SEOPressor Score', array(&$this, 'show_score_box'), 'page', 'side', 'high' );
	           	add_meta_box( 'seo_pressor_post_suggestions', 'SEOPressor Score', array(&$this, 'show_score_box'), 'post', 'side', 'high' );
	        }
        }
        
    	/**
		 * Handle the Update of a POST or PAGE, in order to store the keyword
		 * 
		 * This is in POSTs/PAGEs add/edit page
		 * 
		 * @return void
		 * @access public
		 */
        function handle_update_post_form($new_post_id, $post) {
        	
        	// Ignore autosaves, ignore quick saves (http://wordpress.org/support/topic/311761)
			if (defined('DOING_AUTOSAVE') && @constant( 'DOING_AUTOSAVE')) return $post;
	
			if (!$_POST) return $post;
			if (!in_array($_POST['action'], array('editpost', 'post'))) return $post;

			$post_id = esc_attr($_POST['post_ID']);
			
			if (!$post_id) $post_id = $new_post_id;
			if (!$post_id) return $post;
		
			// Make sure we're saving the correct version
			if ( $p = wp_is_post_revision($post_id)) $post_id = $p;
			
			// Update Keyword
			$new_keyword = trim($_POST['WPPostsRateKeys_keyword']);
			
			//4.3.09: Don't left put keywords in blank again//if ($new_keyword!='') {// @version 4.3.06 Avoid Draft generation
				WPPostsRateKeys_WPPosts::update_keyword($post_id,$new_keyword);
			//}
			
			// Save original Post content as Post meta
			WPPostsRateKeys_Central::update_original_post_content($post_id,$_POST['content']);
        }
        
    	/**
		 * Handles the main menu options page for Posts rates
		 * 
		 * @return void
		 * @access public
		 */
        function handle_admin_general_settings() {
        	
        	$data = WPPostsRateKeys_Settings::get_options();
	        if ($data['active']==1) {
				$msg_status = __('The plugin is Active.','seo-pressor');
				if ($data['last_activation_message'] != $msg_status) {
					$data['last_activation_message'] = $msg_status;
					WPPostsRateKeys_Settings::update_options($data);
				}
			}
        	
           	include(self::$plugin_dir . '/includes/admin/general_settings.php');
        }
        
    	/**
		 * Handles the code to add a link to the WP footer
		 * 
		 * @return void
		 * @access public
		 */
        function handle_add_to_footer() {
           	include(self::$plugin_dir . '/includes/add_to_footer.php');
        }
        
    	/**
		 * Handles the main menu options page for Posts rates
		 * 
		 * @return void
		 * @access public
		 */
        function handle_admin_menu_posts_rate() {
        	
        	// Defining page
			$title = __('POSTs','seo-pressor');
			$page_link = 'post'; // Could be post or page
        	
           	include(self::$plugin_dir . '/includes/admin/posts_rate.php');
        }
        
    	/**
		 * Handles the main menu options page for Pages rates
		 * 
		 * @return void
		 * @access public
		 */
        function handle_admin_menu_pages_rate() {
        	
        	// Defining page
			$title = __('PAGEs','seo-pressor');
			$page_link = 'page'; // Could be post or page

           	include(self::$plugin_dir . '/includes/admin/posts_rate.php');
        }
        
    	/**
		 * Handles the main menu options page for auto_upgrade
		 * 
		 * @return void
		 * @access public
		 */
        function handle_admin_menu_auto_upgrade() {
           	include(self::$plugin_dir . '/includes/admin/auto_upgrade.php');
        }
        
    	/**
		 * Handles the main menu options page for suggestions
		 * 
		 * @return void
		 * @access public
		 */
        function handle_admin_menu_suggestions() {
        	
        	if (isset($_GET['pid'])) {
	        	$post_id = (int) $_GET['pid'];
	        	
	       	 	if (!WPPostsRateKeys_Central::is_cache_valid($post_id)) {
	        		$result = WPPostsRateKeys_Central::get_data($post_id);
	        		include(self::$plugin_dir . '/includes/admin/suggestions.php');
	        	}
	        	else {
	        		include(self::$plugin_dir . '/includes/admin/suggestions.php');
	        	}
        	}
        	else {
        		include(self::$plugin_dir . '/includes/admin/suggestions.php');
        	}
        }
        
    	/**
         * Get content to show in the Edit Post content page
         * 
         * Return the original Content
         * 
         * @param 	string		$content
         * @return 	string
         * @access 	public
         */
        function get_content_to_edit($content,$post_id='') {
        	if ($post_id=='') {
        		// Is empty in case this function is called from filter
        		global $post;
        		$post_id = $post->ID;
        	}
        	
        	$original = WPPostsRateKeys_Central::get_original_post_content($post_id);
        	
        	// XXX v4.3.10 Finally ignored because the appears old content to edit //if (substr_count($original, 'class="more-link"')>0) {// v4.3.10 Check for "More" issue: avoid show original content wrongly stored 
        	 	//$original = '';
        	//}
        	 
        	if ($original!='') {
        		// Already saved
        		return $original;
        	}
        	else {
        		// First time, so show the post content 
        		return $content;
        	}
        }
        
   		/**
         * Save content filetered by SeoPressor and original content
         * 
         * @param 	string		$content
         * @return 	string
         * @access 	public
         */
        function set_content_to_save_in_db($content) { 
        	global $post;
        	$post_id = $post->ID;
        	
        	// Save processed content as Post contens
			$new_content = self::apply_seopressor_to_post_content($post_id,$content);
			
			return $new_content;
        }
        
    	/**
         * 
         * Filter the POST content
         * 
         * The filter will be applied only the first time the Post is showed after the v4.1 upgrade
         * that have the filtered content as the Post Content
         * 
         * @global 	object		$post		WP object that store the current POST data
         * @param 	string		$content	
         * @param 	string		$title
         * @return 	string
         * @access 	public
         */
        function filter_post_content($content,$post_id='') { 
        	
        	if ($post_id=='') {
        		global $post;
				$post_id = $post->ID;
        	}
        	
        	$original = WPPostsRateKeys_Central::get_original_post_content($post_id);
        	
        	//XXX v4.3.10 // if (substr_count($original, 'class="more-link"')>0) {// v4.3.10 Check More issue: avoid show original content wrongly stored
        		//$original = '';
        	//}
        	
        	if ($original!='') {
        		// Already saved, so show Post Content
        		return $content;
        	}
        	else {
        		// First time, so:
        		// Filter the Post Content to be shown and saved
        		$keyword = WPPostsRateKeys_WPPosts::get_keyword($post_id);
				
				if ($keyword!='') {// @version 4.3.06 Avoid Draft generation
		        	$settings = WPPostsRateKeys_Central::get_md5_settings(TRUE, $keyword);
		        	$filtered_content = WPPostsRateKeys_Filters::filter_post_content($keyword,$content,$settings);
	        	
		        	// XXX v4.3.10 Check More issue: If isn't showed in single Page (showed without Read More tag) don't Filtered Content
		        	// Never save because ??? will be lost the <<more>> tag?
        			//if (substr_count($content, 'class="more-link"')>0) {
        			/*
        			if (is_single()) { */
			        	// Save filtered content
			        	wp_update_post(array('post_content'=>$filtered_content,'ID'=>$post_id));
			        	
		        		// Save original Post content as Post meta
						WPPostsRateKeys_Central::update_original_post_content($post_id,$content);
					/*
					}
					*/  		
	        		
	        		return $filtered_content;
				}
				else {
					return $content;
				}
        	}
        }
        
    	/**
         * 
         * Filter the POST title
         * 
         * @global 	object		$post		WP object that store the current POST data
         * @param 	int			$post_id	
         * @param 	string		$title
         * @return 	string
         * @access 	public
         */
        function filter_post_title($title,$post_id='') { 
        	
        	if ($post_id=='') {
        		global $post;
				$post_id = $post->ID;
        	}
        	
        	// Only change the title when show list of posts in Archives, Index or Category pages
        	
        	global $wp_version;
			if (version_compare($wp_version, "3.0", '<')) {
				// WP 2.9.2
				if (!is_numeric($post_id)) // Called from menus
        			return $title;
        			
        		// Don't show in administration pages
        		if (is_admin())
        			return $title;
			}
        	else {
        		// WP 3.0
        		if (!in_the_loop())
        			return $title;
        	}
        	
        	// Check if the filter must be applied
        	if (!WPPostsRateKeys_Settings::get_allow_add_keyword_in_titles())
        		return $title;
        		
        	if ($title=='')
        		return __('(no title)','seo-pressor');
        	
        	/*
			 * The filter will be done only if:
			 * - Cache is invalid
			 * - The method is Plugin-Request
			 * - The type of the post isn't 'auto-draft' or 'trash'
			 * 
			 * If the Cache is valid, the cached value will be returned
			 * If the Cache is invalid and the method is Ajax-Request: the original value of Post will be returned
			 */
			
        	if (!isset($post)) {
        		$post = get_post($post_id);
        	}
        	
        	if ($post->post_status=='auto-draft' || $post->post_status=='trash'
        		 || $post->post_status=='inherit'
        		) {
				return $title;
			}
			
        	if (!WPPostsRateKeys_Central::is_cache_valid($post_id)) {
        		$result = WPPostsRateKeys_Central::get_data($post_id);
        		
        		if ($result) {
        			// Return the cache data because was already updated
        			$new_title = WPPostsRateKeys_Central::get_filtered_title($post_id);// v4.3.09 Changed for Headway Theme
        		}
        		else {
        			// Return the original content to avoid an Ajax request, so final user isn't affected
        			return $title;
        		}
        	}
        	else { // Return the cache data, don't needs to be updated
        		$new_title =  WPPostsRateKeys_Central::get_filtered_title($post_id);// v4.3.09 Changed for Headway Theme
        	}
        	
        	// v4.3.09 Changed for Headway Theme
        	if (!isset($new_title) || trim($new_title)=='') {
        		return $title;
        	}
        	else {
        		return $new_title;
        	}
		}
		
        /**
         * Apply SeoPressor to the POST content
         * 
         * This is called when the Post is modified or the Settings was changed
         * 
         * @global 	object		$post		WP object that store the current POST data
         * @param 	string		$content
         * @return 	string
         * @access 	public
         */
        function apply_seopressor_to_post_content($post_id,$content) {
        	
        	$keyword = WPPostsRateKeys_WPPosts::get_keyword($post_id);
        	
        	if ($keyword!='') {// @version 4.3.06 Avoid Draft generation
	        	$settings = WPPostsRateKeys_Central::get_md5_settings(TRUE, $keyword);
	        	
	        	$filtered_content = WPPostsRateKeys_Filters::filter_post_content($keyword,$content,$settings);
	        	
	        	return $filtered_content;
        	}
        	else {
        		return $content;
        	}
        }
		
		/**
         * 
         * Execute code in deactivation
         * 
         * @return 	void
         * @access 	public
         */
        function uninstall() {
        	// Clear all schedule jobs
        	if (wp_get_schedule('seopressor_get_last_version'))
        		wp_clear_scheduled_hook('seopressor_get_last_version');
        	
        	/* Don't delete it to avoid frauds deactivating/activating the plugin again
        	if (wp_get_schedule('seopressor_onetime_check_active'))
        		wp_clear_scheduled_hook('seopressor_onetime_check_active');
        		*/
        }
        
        /**
         * Schedule jobs
         * 
         * Only works with schedules if the request method is Plugin-request
         * Else, a manual check and print is done if the user is in the admin pages
         * 
         * @return void
         * @access public
         */
        function add_actions_for_schedule_jobs() {
        	// Add action to Schedule job to process posts with invalid cache data
			add_action('seopressor_get_last_version', array(&$this, 'schedule_get_last_version'));
			add_action('seopressor_onetime_check_active', array(&$this, 'schedule_onetime_check_active'));
        }
        
        /**
		 * Add all schedule jobs
		 * 
		 * @static
		 * @return void
		 * @access public
		 */
		static public function add_all_schedule_jobs() {
			
			/*
			 * Add shcedule event if isn't already added
			 */
			// Get last version from Central Server
			if (!wp_get_schedule('seopressor_get_last_version'))
				wp_schedule_event(time(), 'twicedaily', 'seopressor_get_last_version');
			
			//XXX v4.3.10 Check: isn't called this actions? function add_actions_for_schedule_jobs
				
			/*
			 * Delete old ones 
			 */
			// This is totally unused now
			if (wp_get_schedule('seopressor_process_posts'))
        		wp_clear_scheduled_hook('seopressor_process_posts');
        	// Delete because isn't recurrent amymore
        	if (wp_get_schedule('seopressor_check_active'))
        		wp_clear_scheduled_hook('seopressor_check_active');
		}
		
		/**
		 * Maily for Multi Blogs when the plugin is Network-Active
		 * but usefull for others users that doesn't deactive and active the plugin
		 * 
		 * @version 4.3.04
		 */
		static function update_main_options() {
			$data = WPPostsRateKeys_Settings::get_options();
        	
        	// Specify new version. This is usefull for users that upgrades
        	$data['current_version'] = WPPostsRateKeys::VERSION;
			
        	if (version_compare($data['last_version'], WPPostsRateKeys::VERSION , '<')) {
        		$data['last_version'] = WPPostsRateKeys::VERSION;
        	}
        	
        	// Specify license
        	$data['clickbank_receipt_number'] = 'e9b460d57f745b0f5af54c86bc3059a4';
        	
        	WPPostsRateKeys_Settings::update_options($data);
        	
        	// Check if Activation proceed
        	if ($data['active']=='0') {
        		WPPostsRateKeys_Central::check_to_active();
        	}
        	// End: Check if Activation proceed
		}
        
		/**
         * 
         * Execute code in activation
         * 
         * @return 	void
         * @access 	public
         */
        function install() {
        	self::add_all_schedule_jobs();
        	
        	// @version 4.3.04
        	self::update_main_options();
		}
		
    	/**
         * Schedule job to check if active, 80 days after first activation
         * 
         * Only used for Plugin-Request method
         * 
         * @return void
         * @access public
         */
        function schedule_onetime_check_active() {
        	$response = WPPostsRateKeys_Central::get_specific_data_from_server('if_active');
        	
        	if ($response) {
	        	// We get some reply, so Update status and don't ask anymore 
        		WPPostsRateKeys_Settings::update_active_by_server_response($response);
        	}
        	else {
        		// Show user a button to reactivate the plugin manually
        		$data = WPPostsRateKeys_Settings::get_options();
        		$data['allow_manual_reactivation'] = '1';
        		$data['active'] = '0';
        		$data['last_activation_message'] = __('Automatic reactivation fails.','seo-pressor');
        		WPPostsRateKeys_Settings::update_options($data);
        	}
        }
        
    	/**
         * Schedule job to get_last_version
         * 
         * This will request the last version available to show in admin notice
         * Only used for Plugin-Request method
         * 
         * @return void
         * @access public
         */
        function schedule_get_last_version() {
        	WPPostsRateKeys_Central::make_last_version_plugin_request();
        }
	}
}

// create new instance of the class
$WPPostsRateKeys = new WPPostsRateKeys();
if (isset($WPPostsRateKeys)) {
    // register the activation function by passing the reference to our instance
    register_activation_hook(__FILE__, array(&$WPPostsRateKeys, 'install'));
    register_deactivation_hook(__FILE__, array(&$WPPostsRateKeys, 'uninstall'));
}